/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect;

import de.otto.esidialect.Fetch;
import de.otto.esidialect.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsiContentResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EsiContentResolver.class);
    private Fetch fetch;
    private final String prefixForRelativePath;

    public EsiContentResolver(Fetch fetch, String prefixForRelativePath) {
        this.fetch = fetch;
        this.prefixForRelativePath = this.checkPrefix(prefixForRelativePath);
    }

    public String fetch(String src, String templateName, boolean continueOnError) {
        StringBuilder html = new StringBuilder("<!-- <esi:include src=\"" + src + "\"> -->");
        try {
            String url = this.calculateUrl(src);
            Response response = (Response)this.fetch.apply(url);
            int statusCode = response.getStatusCode();
            if (statusCode < 300) {
                html.append(response.getResponseBody());
            } else {
                html.append(this.handleError(src, templateName, statusCode + ": " + response.getStatusText(), null, continueOnError));
            }
        }
        catch (Exception e) {
            html.append(this.handleError(src, templateName, e.getMessage(), e, continueOnError));
        }
        return html.append("<!-- </esi:include> -->").toString();
    }

    private String calculateUrl(String srcAttribute) {
        if (this.prefixForRelativePath != null && srcAttribute.startsWith("/")) {
            return this.prefixForRelativePath + srcAttribute;
        }
        return srcAttribute;
    }

    private String handleError(String srcAttribute, String templateName, String errorMessage, Exception e, boolean continueOnError) {
        LOG.error(String.format("Unable to resolve esi:include src=%s in %s. Request failed with %s", srcAttribute, templateName, errorMessage), (Throwable)e);
        if (continueOnError) {
            return "";
        }
        return errorMessage;
    }

    private String checkPrefix(String prefixForRelativePath) {
        if (!this.isNullOrEmpty(prefixForRelativePath) && !this.prefixStartsWithProtocol(prefixForRelativePath)) {
            throw new IllegalArgumentException("invalid prefix");
        }
        return prefixForRelativePath;
    }

    private boolean isNullOrEmpty(String prefixForRelativePath) {
        return prefixForRelativePath == null || prefixForRelativePath.equals("");
    }

    private boolean prefixStartsWithProtocol(String prefixForRelativePath) {
        return prefixForRelativePath.startsWith("http://") || prefixForRelativePath.startsWith("https://");
    }
}

