/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect;

import de.otto.esidialect.EsiDialectProperties;
import de.otto.esidialect.Fetch;
import de.otto.esidialect.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AsyncHttpClient.class})
public class EsiDialectFetchConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Fetch fetch(String userAgent, EsiDialectProperties properties) {
        Integer timeout = 2000;
        int maxRedirects = 20;
        DefaultAsyncHttpClientConfig cfg = new DefaultAsyncHttpClientConfig.Builder().setConnectTimeout(timeout.intValue()).setRequestTimeout(timeout.intValue()).setFollowRedirect(true).setMaxRedirects(20).setUserAgent(userAgent).build();
        String urlPrefix = properties.isProxyEnabled() ? "http://localhost:" + properties.getProxyPort() : properties.getPrefixForRelativePath();
        return arg_0 -> this.lambda$fetch$0((AsyncHttpClientConfig)cfg, urlPrefix, arg_0);
    }

    private boolean requiresSanitizing(String contentType) {
        return contentType != null && contentType.contains("text/html");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ Response lambda$fetch$0(AsyncHttpClientConfig cfg, String urlPrefix, String src) {
        try (DefaultAsyncHttpClient httpClient = new DefaultAsyncHttpClient(cfg);){
            org.asynchttpclient.Response response = (org.asynchttpclient.Response)httpClient.prepareGet(src).execute().get();
            byte[] responseBodyAsBytes = response.getResponseBodyAsBytes();
            if (this.requiresSanitizing(response.getContentType())) {
                String responseBody = response.getResponseBody();
                String sanitizedEsiIncludesBody = responseBody.replaceAll("href=\"/", "href=\"" + urlPrefix + "/");
                sanitizedEsiIncludesBody = sanitizedEsiIncludesBody.replaceAll("src=\"/", "src=\"" + urlPrefix + "/");
                responseBodyAsBytes = sanitizedEsiIncludesBody.getBytes();
            }
            Response response2 = new Response(response.getStatusCode(), response.getStatusText(), responseBodyAsBytes, response.getContentType());
            return response2;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

