/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect;

import de.otto.esidialect.EsiContentResolver;
import de.otto.esidialect.EsiDialectProperties;
import de.otto.esidialect.Fetch;
import de.otto.esidialect.thymeleaf3.EsiDialect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thymeleaf.processor.element.AbstractElementTagProcessor;

@Configuration
@EnableConfigurationProperties(value={EsiDialectProperties.class})
@ConditionalOnProperty(prefix="esiinclude-thymeleaf-dialect", value={"dialect-enabled"}, havingValue="true")
public class EsiDialectConfiguration {
    @Bean
    @ConditionalOnClass(value={AbstractElementTagProcessor.class})
    @ConditionalOnMissingBean(value={EsiDialect.class})
    public EsiDialect conditionalEsiDialect(EsiContentResolver esiContentResolver) {
        return new EsiDialect(esiContentResolver);
    }

    @Bean
    @ConditionalOnClass(value={AbstractElementTagProcessor.class})
    @ConditionalOnMissingBean(value={EsiContentResolver.class})
    public EsiContentResolver esiContentResolver(Fetch fetch, EsiDialectProperties properties) {
        return new EsiContentResolver(fetch, properties.getPrefixForRelativePath());
    }
}

