/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import de.otto.esidialect.EsiDialectProperties;
import de.otto.esidialect.Fetch;
import de.otto.esidialect.LocalhostProxyConfiguration;
import de.otto.esidialect.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalhostProxyConfiguration.class);
    private HttpServer server;
    private EsiDialectProperties esiDialectProperties;
    private Fetch fetch;

    public LocalhostProxy(EsiDialectProperties esiDialectProperties, Fetch fetch) {
        this.esiDialectProperties = esiDialectProperties;
        this.fetch = fetch;
    }

    @PostConstruct
    public void startProxy() throws IOException {
        if (this.server != null) {
            return;
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress(this.esiDialectProperties.getProxyPort()), 0);
        }
        catch (BindException e) {
            LOGGER.warn("Port already in use. Assuming that the proxy is already running");
            return;
        }
        HttpContext context = this.server.createContext("/");
        context.setHandler(httpExchange -> {
            URI redirectUri = this.changeHostToProxyHost(httpExchange.getRequestURI());
            Response response = (Response)this.fetch.apply(redirectUri.toString());
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            httpExchange.getResponseHeaders().add("Content-Type", response.getContentType());
            httpExchange.sendResponseHeaders(response.getStatusCode(), response.getResponseBodyAsBytes().length);
            OutputStream outputStream = httpExchange.getResponseBody();
            outputStream.write(response.getResponseBodyAsBytes());
            outputStream.flush();
            httpExchange.close();
        });
        this.server.start();
    }

    @PreDestroy
    public void stopProxy() {
        if (this.server != null) {
            LOGGER.info("stopping proxy");
            this.server.stop(0);
        }
    }

    private URI changeHostToProxyHost(URI uri) {
        try {
            return new URI(this.esiDialectProperties.getProxyRedirectProtocol(), this.esiDialectProperties.getProxyRedirectHost(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

