/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import de.otto.esidialect.EsiDialectProperties;
import de.otto.esidialect.Fetch;
import de.otto.esidialect.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EsiDialectProperties.class})
@ConditionalOnProperty(prefix="esiinclude-thymeleaf-dialect", value={"proxy-enabled"}, havingValue="true")
public class LocalhostProxyConfiguration {
    private EsiDialectProperties esiDialectProperties;
    private Fetch fetch;
    private HttpServer server;

    public LocalhostProxyConfiguration(EsiDialectProperties esiDialectProperties, Fetch fetch) {
        this.esiDialectProperties = esiDialectProperties;
        this.fetch = fetch;
    }

    @PostConstruct
    public void startProxy() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(this.esiDialectProperties.getProxyPort()), 0);
        HttpContext context = this.server.createContext("/");
        context.setHandler(httpExchange -> {
            URI redirectUri = this.changeHostToProxyHost(httpExchange.getRequestURI());
            Response response = (Response)this.fetch.apply(redirectUri.toString());
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            httpExchange.getResponseHeaders().add("Content-Type", response.getContentType());
            httpExchange.sendResponseHeaders(response.getStatusCode(), response.getResponseBodyAsBytes().length);
            OutputStream outputStream = httpExchange.getResponseBody();
            outputStream.write(response.getResponseBodyAsBytes());
            outputStream.flush();
            httpExchange.close();
        });
        this.server.start();
    }

    @PreDestroy
    public void stopProxy() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    private URI changeHostToProxyHost(URI uri) {
        try {
            return new URI(this.esiDialectProperties.getProxyRedirectProtocol(), this.esiDialectProperties.getProxyRedirectHost(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

