/*
 * Decompiled with CFR 0.152.
 */
package de.otto.esidialect.thymeleaf3;

import de.otto.esidialect.Fetch;
import de.otto.esidialect.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractElementTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class EsiIncludeElementProcessor
extends AbstractElementTagProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(EsiIncludeElementProcessor.class);
    private Fetch fetch;
    private String prefixForRelativePath;

    protected EsiIncludeElementProcessor(Fetch fetch, String prefixForRelativePath) {
        super(TemplateMode.HTML, "esi", "include", true, null, false, 1000);
        this.fetch = fetch;
        this.prefixForRelativePath = this.checkPrefix(prefixForRelativePath);
    }

    private String checkPrefix(String prefixForRelativePath) {
        if (!this.isNullOrEmpty(prefixForRelativePath) && !this.prefixStartsWithProtocol(prefixForRelativePath)) {
            throw new IllegalArgumentException("invalid prefix");
        }
        return prefixForRelativePath;
    }

    private boolean isNullOrEmpty(String prefixForRelativePath) {
        return prefixForRelativePath == null || prefixForRelativePath.equals("");
    }

    private boolean prefixStartsWithProtocol(String prefixForRelativePath) {
        return prefixForRelativePath.startsWith("http://") || prefixForRelativePath.startsWith("https://");
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, IElementTagStructureHandler structureHandler) {
        String src = tag.getAttributeValue("src");
        String body = this.fetch(src, tag.getTemplateName(), this.continueOnError(tag.getAttributeValue("onerror")));
        structureHandler.replaceWith((CharSequence)body, false);
    }

    String fetch(String srcAttribute, String templateName, boolean continueOnError) {
        StringBuilder html = new StringBuilder("<!-- <esi:include src=\"" + srcAttribute + "\"> -->");
        try {
            String url = this.calculateUrl(srcAttribute);
            Response response = (Response)this.fetch.apply(url);
            int statusCode = response.getStatusCode();
            if (statusCode < 300) {
                html.append(response.getResponseBody());
            } else {
                html.append(this.handleError(srcAttribute, templateName, statusCode + ": " + response.getStatusText(), null, continueOnError));
            }
        }
        catch (Exception e) {
            html.append(this.handleError(srcAttribute, templateName, e.getMessage(), e, continueOnError));
        }
        return html.append("<!-- </esi:include> -->").toString();
    }

    private String calculateUrl(String srcAttribute) {
        if (this.prefixForRelativePath != null && srcAttribute.startsWith("/")) {
            return this.prefixForRelativePath + srcAttribute;
        }
        return srcAttribute;
    }

    private String handleError(String srcAttribute, String templateName, String errorMessage, Exception e, boolean continueOnError) {
        LOG.error(String.format("Unable to resolve esi:include src=%s in %s. Request failed with %s", srcAttribute, templateName, errorMessage), (Throwable)e);
        if (continueOnError) {
            return "";
        }
        return errorMessage;
    }

    private boolean continueOnError(String onerror) {
        return "continue".equals(onerror);
    }
}

