/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.togglz.configuration;

import de.otto.edison.togglz.FeatureClassProvider;
import de.otto.edison.togglz.configuration.TogglzConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

@Configuration
public class InMemoryFeatureStateRepositoryConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={FeatureClassProvider.class})
    public FeatureClassProvider features() {
        return () -> Features.class;
    }

    @Bean
    @ConditionalOnMissingBean(value={StateRepository.class})
    public StateRepository stateRepository() {
        return this.createInMemoryStateRepository();
    }

    private StateRepository createInMemoryStateRepository() {
        return new StateRepository(){
            Logger LOG = LoggerFactory.getLogger(TogglzConfiguration.class);
            private Map<String, FeatureState> featureStore = new HashMap<String, FeatureState>();

            public FeatureState getFeatureState(Feature feature) {
                if (this.featureStore.containsKey(feature.name())) {
                    return this.featureStore.get(feature.name());
                }
                return new FeatureState(feature, false);
            }

            public void setFeatureState(FeatureState featureState) {
                this.featureStore.put(featureState.getFeature().name(), featureState);
                this.LOG.info("Switched feature state to " + featureState.toString());
            }
        };
    }

    public static enum Features implements Feature
    {
        TEST;


        public boolean isActive() {
            return FeatureContext.getFeatureManager().isActive((Feature)this);
        }
    }
}

