/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.togglz.controller;

import de.otto.edison.togglz.FeatureClassProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;

@Immutable
public class TogglzRepresentation {
    private final Map<String, Boolean> togglzState;

    private TogglzRepresentation(Class<Feature> featureClass) {
        this.togglzState = this.buildTogglzState(featureClass);
    }

    public static TogglzRepresentation togglzRepresentation(FeatureClassProvider featureClassProvider) {
        return new TogglzRepresentation(featureClassProvider.getFeatureClass());
    }

    private Map<String, Boolean> buildTogglzState(Class<Feature> featureClass) {
        return Arrays.asList(featureClass.getEnumConstants()).stream().collect(Collectors.toMap(this::toggleName, this::toggleState));
    }

    private boolean toggleState(Feature feature) {
        return FeatureContext.getFeatureManager().isActive(feature);
    }

    private String toggleName(Feature features) {
        return features.name();
    }

    public Map<String, Boolean> getTogglzState() {
        return this.togglzState;
    }
}

