/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.indicator;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CompositeStatusDetailIndicator
implements StatusDetailIndicator {
    private final String name;
    private final List<StatusDetailIndicator> delegates;

    public CompositeStatusDetailIndicator(String name, List<StatusDetailIndicator> delegates) {
        this.name = name;
        this.delegates = delegates;
        if (delegates == null || delegates.isEmpty()) {
            throw new IllegalArgumentException("CompositeStatusDetailIndicator " + name + " does not have any delegate indicators");
        }
    }

    @Override
    public StatusDetail statusDetail() {
        if (this.delegates.size() == 1) {
            return this.delegates.get(0).statusDetail();
        }
        return StatusDetail.statusDetail(this.name, this.delegates.stream().map(StatusDetailIndicator::statusDetails).flatMap(Collection::stream).map(StatusDetail::getStatus).reduce(Status.OK, Status::plus), "Aggregated status of " + this.delegates.size() + " delegate indicators");
    }

    @Override
    public List<StatusDetail> statusDetails() {
        return this.delegates.stream().map(StatusDetailIndicator::statusDetails).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

