/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.configuration;

import de.otto.edison.status.domain.VersionInfo;
import de.otto.edison.status.indicator.ApplicationStatusAggregator;
import de.otto.edison.status.indicator.CachedApplicationStatusAggregator;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import de.otto.edison.status.scheduler.CronScheduler;
import de.otto.edison.status.scheduler.EveryTenSecondsScheduler;
import de.otto.edison.status.scheduler.Scheduler;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
public class StatusConfiguration {
    @Autowired(required=false)
    private List<StatusDetailIndicator> statusDetailIndicators = Collections.emptyList();
    @Autowired
    private VersionInfo versionInfo;
    @Value(value="${edison.application.name}")
    private String applicationName;

    @Bean
    @ConditionalOnMissingBean(value={ApplicationStatusAggregator.class})
    public ApplicationStatusAggregator applicationStatusAggregator() {
        return new CachedApplicationStatusAggregator(this.applicationName, this.versionInfo, this.statusDetailIndicators);
    }

    @Bean
    @ConditionalOnProperty(name={"edison.status.scheduler.cron"})
    public Scheduler cronScheduler() {
        return new CronScheduler(this.applicationStatusAggregator());
    }

    @Bean
    @ConditionalOnMissingBean(value={Scheduler.class})
    public Scheduler fixedDelayScheduler() {
        return new EveryTenSecondsScheduler(this.applicationStatusAggregator());
    }
}

