/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.controller;

import de.otto.edison.status.controller.ApplicationStatusRepresentation;
import de.otto.edison.status.controller.UrlHelper;
import de.otto.edison.status.domain.ApplicationStatus;
import de.otto.edison.status.indicator.ApplicationStatusAggregator;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@ConfigurationProperties(value="endpoints.status", ignoreUnknownFields=false)
@RestController
public class StatusController {
    private static final String SYSTEM_START_TIME = ZonedDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG));
    @Autowired
    private ApplicationStatusAggregator aggregator;

    public StatusController() {
    }

    public StatusController(ApplicationStatusAggregator aggregator) {
        this.aggregator = aggregator;
    }

    @RequestMapping(value={"/internal/status"}, produces={"application/vnd.otto.monitoring.status+json", "application/json"}, method={RequestMethod.GET})
    public ApplicationStatusRepresentation getStatusAsJson() {
        return ApplicationStatusRepresentation.statusRepresentationOf(this.aggregator.aggregatedStatus());
    }

    @RequestMapping(value={"/internal/status"}, produces={"text/html"}, method={RequestMethod.GET})
    public ModelAndView getStatusAsHtml(final HttpServletRequest request) {
        final ApplicationStatus applicationStatus = this.aggregator.aggregatedStatus();
        return new ModelAndView("status"){
            {
                super(x0);
                this.addObject("status", applicationStatus.getStatus().name());
                this.addObject("name", applicationStatus.getName());
                this.addObject("hostname", applicationStatus.getHostName());
                this.addObject("systemtime", ZonedDateTime.now().format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG)));
                this.addObject("systemstarttime", SYSTEM_START_TIME);
                this.addObject("version", applicationStatus.getVersionInfo().getVersion());
                this.addObject("commit", applicationStatus.getVersionInfo().getCommit());
                this.addObject("statusDetails", StatusController.this.statusDetails(applicationStatus));
                this.addObject("baseUri", UrlHelper.baseUriOf(request));
            }
        };
    }

    private Collection<Map<String, ?>> statusDetails(ApplicationStatus applicationStatus) {
        return applicationStatus.getStatusDetails().stream().map(detail -> new LinkedHashMap<String, Object>(){
            {
                this.put("key", detail.getName());
                this.put("status", detail.getStatus().name());
                this.put("message", detail.getMessage());
                this.put("additionalDetails", detail.getDetails());
            }
        }).collect(Collectors.toList());
    }
}

