/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.indicator;

import de.otto.edison.status.domain.ApplicationStatus;
import de.otto.edison.status.domain.VersionInfo;
import de.otto.edison.status.indicator.ApplicationStatusAggregator;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CachedApplicationStatusAggregator
implements ApplicationStatusAggregator {
    private volatile ApplicationStatus cachedStatus;
    private final String applicationName;
    private final VersionInfo versionInfo;
    private final List<StatusDetailIndicator> indicators;
    private final String hostName;

    public CachedApplicationStatusAggregator(String applicationName, VersionInfo versionInfo, List<StatusDetailIndicator> indicators) {
        this.applicationName = applicationName;
        this.versionInfo = versionInfo;
        this.indicators = Collections.unmodifiableList(new ArrayList<StatusDetailIndicator>(indicators));
        this.hostName = this.hostName();
        this.cachedStatus = ApplicationStatus.applicationStatus(applicationName, this.hostName, versionInfo, Collections.emptyList());
    }

    @Override
    public ApplicationStatus aggregatedStatus() {
        return this.cachedStatus;
    }

    @Override
    public void update() {
        this.cachedStatus = this.calcApplicationStatus();
    }

    private ApplicationStatus calcApplicationStatus() {
        return ApplicationStatus.applicationStatus(this.applicationName, this.hostName, this.versionInfo, this.indicators.stream().map(StatusDetailIndicator::statusDetail).collect(Collectors.toList()));
    }

    private String hostName() {
        try {
            String envHost = System.getenv("HOST");
            if (envHost != null) {
                return envHost;
            }
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "UNKOWN";
        }
    }
}

