/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.domain;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.domain.VersionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class ApplicationStatus {
    private final String name;
    private final Status status;
    private final List<StatusDetail> statusDetails;
    private final VersionInfo versionInfo;
    private final String hostName;

    private ApplicationStatus(String applicationName, String hostName, VersionInfo versionInfo, List<StatusDetail> details) {
        this.name = applicationName;
        this.versionInfo = versionInfo;
        this.hostName = hostName;
        this.status = details.stream().map(StatusDetail::getStatus).reduce(Status.OK, Status::plus);
        this.statusDetails = Collections.unmodifiableList(new ArrayList<StatusDetail>(details));
    }

    public static ApplicationStatus applicationStatus(String applicationName, String hostName, VersionInfo versionInfo, List<StatusDetail> details) {
        return new ApplicationStatus(applicationName, hostName, versionInfo, details);
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getHostName() {
        return this.hostName;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public List<StatusDetail> getStatusDetails() {
        return this.statusDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationStatus that = (ApplicationStatus)o;
        if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.statusDetails != null ? !this.statusDetails.equals(that.statusDetails) : that.statusDetails != null) {
            return false;
        }
        return !(this.versionInfo != null ? !this.versionInfo.equals(that.versionInfo) : that.versionInfo != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.statusDetails != null ? this.statusDetails.hashCode() : 0);
        result = 31 * result + (this.versionInfo != null ? this.versionInfo.hashCode() : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ApplicationStatus{hostName='" + this.hostName + '\'' + ", name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", statusDetails=" + this.statusDetails + ", versionInfo=" + this.versionInfo + '}';
    }
}

