/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.status.controller;

import de.otto.edison.status.domain.ApplicationStatus;
import de.otto.edison.status.domain.StatusDetail;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
final class ApplicationStatusRepresentation {
    private final ApplicationStatus applicationStatus;

    private ApplicationStatusRepresentation(ApplicationStatus applicationStatus) {
        this.applicationStatus = applicationStatus;
    }

    public static ApplicationStatusRepresentation statusRepresentationOf(ApplicationStatus status) {
        return new ApplicationStatusRepresentation(status);
    }

    public Map<String, ?> getApplication() {
        return new LinkedHashMap<String, Object>(){
            {
                this.put("status", ApplicationStatusRepresentation.this.applicationStatus.getStatus().name());
                this.put("name", ApplicationStatusRepresentation.this.applicationStatus.getName());
                this.put("hostname", ApplicationStatusRepresentation.this.applicationStatus.getHostName());
                this.put("commit", ApplicationStatusRepresentation.this.applicationStatus.getVersionInfo().getCommit());
                this.put("version", ApplicationStatusRepresentation.this.applicationStatus.getVersionInfo().getVersion());
                this.put("statusDetails", ApplicationStatusRepresentation.this.statusDetailsRepresentationOf(ApplicationStatusRepresentation.this.applicationStatus));
            }
        };
    }

    private Map<String, ?> statusDetailsRepresentationOf(ApplicationStatus applicationStatus) {
        LinkedHashMap<String, 2> map = new LinkedHashMap<String, 2>();
        for (final StatusDetail entry : applicationStatus.getStatusDetails()) {
            map.put(entry.getName(), new LinkedHashMap<String, String>(){
                {
                    this.put("status", entry.getStatus().name());
                    this.put("message", entry.getMessage());
                    this.putAll(entry.getDetails());
                }
            });
        }
        return map;
    }
}

