/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.discovery.client;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import de.otto.edison.discovery.client.DiscoveryClient;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"edison.servicediscovery.servers"})
public class EdisonDiscoveryClient
implements DiscoveryClient {
    private static final Logger LOG = LoggerFactory.getLogger(EdisonDiscoveryClient.class);
    @Autowired
    private AsyncHttpClient httpClient;
    @Value(value="${edison.servicediscovery.servers}")
    private String discoveryServers;
    @Value(value="${edison.servicediscovery.service}")
    private String serviceUrl;
    @Value(value="${edison.servicediscovery.expire-after:15}")
    private long expireAfterMinutes;
    @Value(value="${edison.servicediscovery.refresh-after:5}")
    private long refreshAfterMinutes;
    @Value(value="${edison.application.name}")
    private String applicationName;
    @Value(value="${edison.servicediscovery.environment:unknown}")
    private String applicationEnvironment;
    @Value(value="${edison.servicediscovery.group:default}")
    private String applicationGroup;

    @PostConstruct
    public void postConstruct() {
        LOG.info("Scheduling registration at Edison JobTrigger every {} minutes.", (Object)this.refreshAfterMinutes);
        Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(this::registerService, 0L, this.refreshAfterMinutes, TimeUnit.MINUTES);
    }

    @Override
    public void registerService() {
        Arrays.stream(this.discoveryServers.split(",")).forEach(discoveryServer -> {
            try {
                LOG.debug("Updating registration of service at " + discoveryServer);
                this.httpClient.preparePut(discoveryServer + "/environments/" + this.applicationEnvironment + "/" + this.applicationName).setHeader("Content-Type", "application/vnd.otto.edison.links+json").setHeader("Accept", "application/vnd.otto.edison.links+json").setBody("{\n   \"groups\":[\"" + this.applicationGroup + "\"],\n" + "   \"expire\":" + this.expireAfterMinutes + ",\n" + "   \"links\":[{\n" + "      \"rel\":\"http://github.com/otto-de/edison/link-relations/microservice\",\n" + "      \"href\" : \"" + this.serviceUrl + "\",\n" + "      \"title\":\"" + this.applicationName + "\"\n" + "   }]  \n" + "}").execute((AsyncHandler)new AsyncCompletionHandler<Integer>(){

                    public Integer onCompleted(Response response) throws Exception {
                        if (response.getStatusCode() < 300) {
                            LOG.info("Successfully updated registration at " + discoveryServer);
                        } else {
                            LOG.warn("Failed to update registration at " + discoveryServer + ": Status=" + response.getStatusCode() + " " + response.getStatusText());
                        }
                        return response.getStatusCode();
                    }

                    public void onThrowable(Throwable t) {
                        LOG.error("Failed to register at " + discoveryServer + ": " + t.getMessage());
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Error updating registration: " + e.getMessage());
            }
        });
    }
}

