/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.service;

import de.otto.edison.jobs.definition.JobDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobDefinitionService {
    private static final Logger LOG = LoggerFactory.getLogger(JobDefinitionService.class);
    @Autowired(required=false)
    private List<JobDefinition> jobDefinitions = new ArrayList<JobDefinition>();

    public JobDefinitionService() {
    }

    public JobDefinitionService(List<JobDefinition> jobDefinitions) {
        this.jobDefinitions = jobDefinitions;
    }

    @PostConstruct
    public void postConstruct() {
        LOG.info("Initializing JobDefinitionService...");
        if (this.jobDefinitions == null) {
            this.jobDefinitions = Collections.emptyList();
        }
        if (this.jobDefinitions.size() == 0) {
            LOG.info("No JobDefinitions found in microservice.");
            return;
        }
        LOG.info("Found " + this.jobDefinitions.size() + " JobDefinitions: " + this.jobDefinitions.stream().map(JobDefinition::jobType).collect(Collectors.toList()));
    }

    public List<JobDefinition> getJobDefinitions() {
        return new ArrayList<JobDefinition>(this.jobDefinitions);
    }

    public Optional<JobDefinition> getJobDefinition(String jobType) {
        return this.jobDefinitions.stream().filter(j -> j.jobType().equals(jobType)).findAny();
    }
}

