/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.service;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.monitor.JobMonitor;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.service.JobRunnable;
import de.otto.edison.jobs.service.JobRunner;
import de.otto.edison.jobs.service.JobService;
import java.net.URI;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.GaugeService;

public class DefaultJobService
implements JobService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJobService.class);
    @Autowired
    private JobMonitor monitor;
    @Autowired
    private JobRepository repository;
    @Autowired
    private ScheduledExecutorService executor;
    @Autowired
    private GaugeService gaugeService;
    @Autowired(required=false)
    private List<JobRunnable> jobRunnables = Collections.emptyList();
    private final Clock clock;

    public DefaultJobService() {
        this.clock = Clock.systemDefaultZone();
    }

    DefaultJobService(JobRepository repository, JobMonitor monitor, List<JobRunnable> jobRunnables, GaugeService gaugeService, Clock clock, ScheduledExecutorService executor) {
        this.repository = repository;
        this.monitor = monitor;
        this.repository = repository;
        this.jobRunnables = jobRunnables;
        this.gaugeService = gaugeService;
        this.clock = clock;
        this.executor = executor;
    }

    @PostConstruct
    public void postConstruct() {
        LOG.info("Found {} JobRunnables: {}", (Object)this.jobRunnables.size(), this.jobRunnables.stream().map(JobRunnable::getJobType).collect(Collectors.toList()));
    }

    @Override
    public Optional<URI> startAsyncJob(String jobType) {
        Optional<JobRunnable> jobRunnable = this.jobRunnables.stream().filter(r -> r.getJobType().equalsIgnoreCase(jobType)).findFirst();
        return this.startAsyncJob(jobRunnable.orElseThrow(() -> new IllegalArgumentException("No JobRunnable for " + jobType)));
    }

    @Override
    public Optional<URI> startAsyncJob(JobRunnable jobRunnable) {
        Optional<JobInfo> alreadyRunning = this.repository.findRunningJobByType(jobRunnable.getJobType());
        if (alreadyRunning == null || !alreadyRunning.isPresent()) {
            return Optional.of(this.startAsync(this.metered(jobRunnable)));
        }
        URI jobUri = alreadyRunning.get().getJobUri();
        LOG.info("Job {} triggered but not started - still running.", (Object)jobUri);
        return Optional.empty();
    }

    @Override
    public Optional<JobInfo> findJob(URI uri) {
        return this.repository.findOne(uri);
    }

    @Override
    public List<JobInfo> findJobs(Optional<String> type, int count) {
        if (type.isPresent()) {
            return this.repository.findLatestBy(type.get(), count);
        }
        return this.repository.findLatest(count);
    }

    @Override
    public void deleteJobs(Optional<String> type) {
        if (type.isPresent()) {
            this.repository.findByType(type.get()).forEach(j -> this.repository.removeIfStopped(j.getJobUri()));
        } else {
            this.repository.findAll().forEach(j -> this.repository.removeIfStopped(j.getJobUri()));
        }
    }

    private URI startAsync(JobRunnable jobRunnable) {
        JobInfo jobInfo = JobInfo.newJobInfo(this.newJobUri(), jobRunnable.getJobType(), this.monitor, this.clock);
        JobRunner jobRunner = JobRunner.newJobRunner(jobInfo, this.repository, this.executor);
        this.executor.execute(() -> jobRunner.start(jobRunnable));
        return jobInfo.getJobUri();
    }

    private JobRunnable metered(final JobRunnable delegate) {
        return new JobRunnable(){

            @Override
            public String getJobType() {
                return delegate.getJobType();
            }

            @Override
            public void execute(JobInfo jobInfo) {
                long ts = System.currentTimeMillis();
                delegate.execute(jobInfo);
                DefaultJobService.this.gaugeService.submit(this.gaugeName(), (double)((System.currentTimeMillis() - ts) / 1000L));
            }

            private String gaugeName() {
                return "gauge.jobs.runtime." + delegate.getJobType().toLowerCase();
            }
        };
    }

    private URI newJobUri() {
        return URI.create("/internal/jobs/" + UUID.randomUUID());
    }
}

