/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.repository.inmem;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.repository.JobRepository;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class InMemJobRepository
implements JobRepository {
    private static final Comparator<JobInfo> STARTED_TIME_DESC_COMPARATOR = Comparator.comparing(JobInfo::getStarted, Comparator.reverseOrder());
    private final ConcurrentMap<URI, JobInfo> jobs = new ConcurrentHashMap<URI, JobInfo>();

    @Override
    public List<JobInfo> findLatest(int maxCount) {
        return new ArrayList<JobInfo>(this.jobs.values().stream().sorted(STARTED_TIME_DESC_COMPARATOR).limit(maxCount).collect(Collectors.toList()));
    }

    @Override
    public Optional<JobInfo> findOne(URI uri) {
        return Optional.ofNullable(this.jobs.get(uri));
    }

    @Override
    public List<JobInfo> findLatestBy(String type, int maxCount) {
        return this.jobs.values().stream().sorted(STARTED_TIME_DESC_COMPARATOR).filter(jobInfo -> jobInfo.getJobType().equals(type)).collect(Collectors.toList());
    }

    @Override
    public List<JobInfo> findRunningWithoutUpdateSince(OffsetDateTime timeOffset) {
        return this.jobs.values().stream().filter(jobInfo -> !jobInfo.isStopped() && jobInfo.getLastUpdated().isBefore(timeOffset)).collect(Collectors.toList());
    }

    @Override
    public List<JobInfo> findAll() {
        return this.jobs.values().stream().sorted(STARTED_TIME_DESC_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public List<JobInfo> findByType(String jobType) {
        return this.jobs.values().stream().filter(jobInfo -> jobInfo.getJobType().equals(jobType)).collect(Collectors.toList());
    }

    @Override
    public Optional<JobInfo> findRunningJobByType(String jobType) {
        List runningJobsOfType = this.jobs.values().stream().filter(job -> job.getJobType().equals(jobType) && !job.getStopped().isPresent()).collect(Collectors.toList());
        return Optional.ofNullable(runningJobsOfType.isEmpty() ? null : (JobInfo)runningJobsOfType.get(0));
    }

    @Override
    public void createOrUpdate(JobInfo job) {
        this.jobs.put(job.getJobUri(), job);
    }

    @Override
    public void removeIfStopped(URI uri) {
        JobInfo jobInfo = (JobInfo)this.jobs.get(uri);
        if (jobInfo != null && jobInfo.isStopped()) {
            this.jobs.remove(uri);
        }
    }

    @Override
    public long size() {
        return this.jobs.size();
    }

    @Override
    public JobInfo.JobStatus findStatus(URI jobUri) {
        return ((JobInfo)this.jobs.get(jobUri)).getStatus();
    }
}

