/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.repository.cleanup;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.repository.cleanup.JobCleanupStrategy;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class StopDeadJobs
implements JobCleanupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(StopDeadJobs.class);
    private static final long STOP_DEAD_JOBS_CLEANUP_INTERVAL = 600000L;
    private final int stopJobAfterSeconds;
    private final Clock clock;
    private JobRepository jobRepository;

    public StopDeadJobs(int stopJobAfterSeconds, Clock clock) {
        this.stopJobAfterSeconds = stopJobAfterSeconds;
        this.clock = clock;
        LOG.info("Mark old as stopped after '{}' seconds of inactivity", (Object)stopJobAfterSeconds);
    }

    @Autowired
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Override
    @Scheduled(fixedRate=600000L)
    public void doCleanUp() {
        OffsetDateTime now = OffsetDateTime.now(this.clock);
        OffsetDateTime timeToMarkJobAsStopped = now.minusSeconds(this.stopJobAfterSeconds);
        LOG.info(String.format("JobCleanup: Looking for jobs older than %s ", timeToMarkJobAsStopped));
        List<JobInfo> deadJobs = this.jobRepository.findRunningWithoutUpdateSince(timeToMarkJobAsStopped);
        deadJobs.forEach(j -> {
            j.dead();
            this.jobRepository.createOrUpdate((JobInfo)j);
        });
    }
}

