/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.repository.cleanup;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.repository.cleanup.JobCleanupStrategy;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class KeepLastJobs
implements JobCleanupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(KeepLastJobs.class);
    private static final long KEEP_LAST_JOBS_CLEANUP_INTERVAL = 600000L;
    private final int numberOfJobsToKeep;
    private final Optional<String> jobType;
    private JobRepository jobRepository;

    public KeepLastJobs(int numberOfJobsToKeep, Optional<String> jobType) {
        this.numberOfJobsToKeep = numberOfJobsToKeep;
        this.jobType = jobType;
        LOG.info("KeepLastJobs strategy configured with numberOfJobsToKeep= '{}', jobType= '{}'", (Object)numberOfJobsToKeep, (Object)jobType.toString());
    }

    @Autowired
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    @Override
    @Scheduled(fixedRate=600000L)
    public void doCleanUp() {
        List<JobInfo> jobs;
        List<JobInfo> list = jobs = this.jobType.isPresent() ? this.jobRepository.findByType(this.jobType.get()) : this.jobRepository.findAll();
        if (jobs.size() > this.numberOfJobsToKeep) {
            this.findJobsToDelete(jobs).forEach(jobInfo -> this.jobRepository.removeIfStopped(jobInfo.getJobUri()));
        }
    }

    private List<JobInfo> findJobsToDelete(List<JobInfo> jobs) {
        int numberOfJobsToDelete = jobs.size() - this.numberOfJobsToKeep;
        List<JobInfo> lastOKJobs = this.findLastOKJobs(jobs);
        return jobs.stream().filter(j -> j.isStopped() && !lastOKJobs.contains(j)).sorted(Comparator.comparing(JobInfo::getStarted)).limit(numberOfJobsToDelete).collect(Collectors.toList());
    }

    private List<JobInfo> findLastOKJobs(List<JobInfo> jobs) {
        Map<String, List<JobInfo>> jobsGroupedByType = jobs.stream().collect(Collectors.groupingBy(JobInfo::getJobType));
        return jobsGroupedByType.entrySet().stream().map(entry -> ((List)entry.getValue()).stream().filter(j -> j.isStopped() && j.getStatus() == JobInfo.JobStatus.OK).sorted(Comparator.comparing(JobInfo::getStarted, Comparator.reverseOrder())).findFirst()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

