/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.domain;

import de.otto.edison.jobs.domain.JobMessage;
import de.otto.edison.jobs.domain.Level;
import de.otto.edison.jobs.monitor.JobMonitor;
import java.net.URI;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JobInfo {
    private static final String JOB_DEAD_MESSAGE = "Job didn't receive updates for a while, considering it dead";
    private final JobMonitor monitor;
    private final Clock clock;
    private final URI jobUri;
    private final String jobType;
    private final OffsetDateTime started;
    private final List<JobMessage> messages = new ArrayList<JobMessage>();
    private Optional<OffsetDateTime> stopped;
    private JobStatus status;
    private OffsetDateTime lastUpdated;

    public static JobInfo newJobInfo(URI jobUri, String jobType, JobMonitor monitor, Clock clock) {
        return new JobInfo(jobType, jobUri, monitor, clock);
    }

    public static JobInfo newJobInfo(URI jobUri, String jobType, OffsetDateTime started, OffsetDateTime lastUpdated, Optional<OffsetDateTime> stopped, JobStatus status, List<JobMessage> messages, JobMonitor monitor, Clock clock) {
        return new JobInfo(jobUri, jobType, started, lastUpdated, stopped, status, messages, monitor, clock);
    }

    JobInfo(String jobType, URI jobUri, JobMonitor monitor, Clock clock) {
        this.clock = clock;
        this.jobUri = jobUri;
        this.jobType = jobType;
        this.started = OffsetDateTime.now(clock);
        this.stopped = Optional.empty();
        this.status = JobStatus.OK;
        this.monitor = monitor;
        this.lastUpdated = this.started;
        this.messages.add(JobMessage.jobMessage(Level.INFO, "Started " + jobType));
        this.monitor.update(this);
    }

    JobInfo(URI jobUri, String jobType, OffsetDateTime started, OffsetDateTime lastUpdated, Optional<OffsetDateTime> stopped, JobStatus status, List<JobMessage> messages, JobMonitor monitor, Clock clock) {
        this.clock = clock;
        this.monitor = monitor;
        this.jobUri = jobUri;
        this.jobType = jobType;
        this.started = started;
        this.lastUpdated = lastUpdated;
        this.stopped = stopped;
        this.status = status;
        this.messages.addAll(messages);
    }

    public synchronized boolean isStopped() {
        return this.stopped.isPresent();
    }

    public URI getJobUri() {
        return this.jobUri;
    }

    public String getJobType() {
        return this.jobType;
    }

    public OffsetDateTime getStarted() {
        return this.started;
    }

    public synchronized JobStatus getStatus() {
        return this.status;
    }

    public synchronized String getState() {
        return this.isStopped() ? "STOPPED" : "RUNNING";
    }

    public synchronized Optional<OffsetDateTime> getStopped() {
        return this.stopped;
    }

    public synchronized List<JobMessage> getMessages() {
        return new ArrayList<JobMessage>(this.messages);
    }

    public synchronized OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public synchronized void ping() {
        this.lastUpdated = OffsetDateTime.now(this.clock);
        this.monitor.update(this);
    }

    public synchronized JobInfo info(String message) {
        this.messages.add(JobMessage.jobMessage(Level.INFO, message));
        this.lastUpdated = OffsetDateTime.now(this.clock);
        this.monitor.update(this);
        return this;
    }

    public synchronized JobInfo error(String message) {
        this.messages.add(JobMessage.jobMessage(Level.ERROR, message));
        this.lastUpdated = OffsetDateTime.now(this.clock);
        this.status = JobStatus.ERROR;
        this.monitor.update(this);
        return this;
    }

    public synchronized JobInfo stop() {
        this.lastUpdated = OffsetDateTime.now(this.clock);
        this.stopped = Optional.of(this.lastUpdated);
        this.monitor.update(this);
        return this;
    }

    public synchronized JobInfo dead() {
        this.messages.add(JobMessage.jobMessage(Level.WARNING, JOB_DEAD_MESSAGE));
        this.lastUpdated = OffsetDateTime.now(this.clock);
        this.stopped = Optional.of(this.lastUpdated);
        this.status = JobStatus.DEAD;
        this.monitor.update(this);
        return this;
    }

    JobMonitor getMonitor() {
        return this.monitor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobInfo jobInfo = (JobInfo)o;
        if (this.jobType != null ? !this.jobType.equals(jobInfo.jobType) : jobInfo.jobType != null) {
            return false;
        }
        if (this.jobUri != null ? !this.jobUri.equals(jobInfo.jobUri) : jobInfo.jobUri != null) {
            return false;
        }
        if (this.lastUpdated != null ? !this.lastUpdated.equals(jobInfo.lastUpdated) : jobInfo.lastUpdated != null) {
            return false;
        }
        if (this.messages != null ? !this.messages.equals(jobInfo.messages) : jobInfo.messages != null) {
            return false;
        }
        if (this.started != null ? !this.started.equals(jobInfo.started) : jobInfo.started != null) {
            return false;
        }
        if (this.status != jobInfo.status) {
            return false;
        }
        return !(this.stopped != null ? !this.stopped.equals(jobInfo.stopped) : jobInfo.stopped != null);
    }

    public int hashCode() {
        int result = this.jobUri != null ? this.jobUri.hashCode() : 0;
        result = 31 * result + (this.jobType != null ? this.jobType.hashCode() : 0);
        result = 31 * result + (this.started != null ? this.started.hashCode() : 0);
        result = 31 * result + (this.stopped != null ? this.stopped.hashCode() : 0);
        result = 31 * result + (this.messages != null ? this.messages.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.lastUpdated != null ? this.lastUpdated.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JobInfo{jobUri=" + this.jobUri + ", jobType=" + this.jobType + ", started=" + this.started + ", stopped=" + this.stopped + ", messages=" + this.messages + ", status=" + (Object)((Object)this.status) + ", lastUpdated=" + this.lastUpdated + '}';
    }

    public static enum JobStatus {
        OK,
        ERROR,
        DEAD;

    }
}

