/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.definition;

import de.otto.edison.jobs.definition.JobDefinition;
import java.time.Duration;
import java.util.Optional;

public final class DefaultJobDefinition
implements JobDefinition {
    private final String jobType;
    private final String jobName;
    private final String description;
    private final Optional<Duration> maxAge;
    private final Optional<Duration> fixedDelay;
    private final Optional<String> cron;
    private final int retries;
    private final Optional<Duration> retryDelay;

    public static JobDefinition cronJobDefinition(String jobType, String jobName, String description, String cron, Optional<Duration> maxAge) {
        return new DefaultJobDefinition(jobType, jobName, description, maxAge, Optional.empty(), Optional.of(cron), 0, Optional.empty());
    }

    public static JobDefinition notTriggerableJobDefinition(String jobType, String jobName, String description) {
        return new DefaultJobDefinition(jobType, jobName, description, Optional.empty(), Optional.empty(), Optional.empty(), 0, Optional.empty());
    }

    public static JobDefinition retryableCronJobDefinition(String jobType, String jobName, String description, String cron, int retries, Duration retryDelay, Optional<Duration> maxAge) {
        return new DefaultJobDefinition(jobType, jobName, description, maxAge, Optional.empty(), Optional.of(cron), retries, Optional.of(retryDelay));
    }

    public static DefaultJobDefinition fixedDelayJobDefinition(String jobType, String jobName, String description, Duration fixedDelay, Optional<Duration> maxAge) {
        return new DefaultJobDefinition(jobType, jobName, description, maxAge, Optional.of(fixedDelay), Optional.empty(), 0, Optional.empty());
    }

    public static DefaultJobDefinition retryableFixedDelayJobDefinition(String jobType, String jobName, String description, Duration fixedDelay, int retries, Optional<Duration> retryDelay, Optional<Duration> maxAge) {
        return new DefaultJobDefinition(jobType, jobName, description, maxAge, Optional.of(fixedDelay), Optional.empty(), retries, retryDelay);
    }

    private DefaultJobDefinition(String jobType, String jobName, String description, Optional<Duration> maxAge, Optional<Duration> fixedDelay, Optional<String> cron, int retries, Optional<Duration> retryDelay) {
        this.jobType = jobType;
        this.jobName = jobName;
        this.description = description;
        this.maxAge = maxAge;
        this.fixedDelay = fixedDelay;
        this.cron = cron;
        this.retries = retries;
        this.retryDelay = retryDelay;
    }

    @Override
    public String jobType() {
        return this.jobType;
    }

    @Override
    public String jobName() {
        return this.jobName;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Optional<Duration> maxAge() {
        return this.maxAge;
    }

    @Override
    public Optional<Duration> fixedDelay() {
        return this.fixedDelay;
    }

    @Override
    public Optional<String> cron() {
        return this.cron;
    }

    @Override
    public int retries() {
        return this.retries;
    }

    @Override
    public Optional<Duration> retryDelay() {
        return this.retryDelay;
    }
}

