/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.controller;

import de.otto.edison.jobs.controller.JobRepresentation;
import de.otto.edison.jobs.controller.UrlHelper;
import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.service.JobService;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class JobsController {
    private static final Logger LOG = LoggerFactory.getLogger(JobsController.class);
    @Autowired
    private JobService jobService;
    @Value(value="${server.context-path}")
    private String serverContextPath;

    public JobsController() {
    }

    JobsController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/internal/jobs"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView getJobsAsHtml(@RequestParam(value="type", required=false) String type, @RequestParam(value="count", defaultValue="100") int count, HttpServletRequest request) {
        List jobRepresentations = this.jobService.findJobs(Optional.ofNullable(type), count).stream().map(j -> JobRepresentation.representationOf(j, true, UrlHelper.baseUriOf(request))).collect(Collectors.toList());
        ModelAndView modelAndView = new ModelAndView("jobs");
        modelAndView.addObject("jobs", jobRepresentations);
        return modelAndView;
    }

    @RequestMapping(value={"/internal/jobs"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<JobRepresentation> getJobsAsJson(@RequestParam(value="type", required=false) String type, @RequestParam(value="count", defaultValue="100") int count, HttpServletRequest request) {
        return this.jobService.findJobs(Optional.ofNullable(type), count).stream().map(j -> JobRepresentation.representationOf(j, false, UrlHelper.baseUriOf(request))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/internal/jobs"}, method={RequestMethod.DELETE})
    public void deleteJobs(@RequestParam(value="type", required=false) String type) {
        this.jobService.deleteJobs(Optional.ofNullable(type));
    }

    @RequestMapping(value={"/internal/jobs/{jobType}"}, method={RequestMethod.POST})
    public void startJob(@PathVariable String jobType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional<URI> jobUri = this.jobService.startAsyncJob(jobType);
        if (jobUri.isPresent()) {
            response.setHeader("Location", UrlHelper.baseUriOf(request) + jobUri.get().toString());
            response.setStatus(204);
        } else {
            response.sendError(409);
        }
    }

    @RequestMapping(value={"/internal/jobs/{id}"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView getJobAsHtml(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setCorsHeaders(response);
        Optional<JobInfo> optionalJob = this.jobService.findJob(this.jobUriOf(request));
        if (optionalJob.isPresent()) {
            ModelAndView modelAndView = new ModelAndView("job");
            modelAndView.addObject("job", (Object)JobRepresentation.representationOf(optionalJob.get(), true, UrlHelper.baseUriOf(request)));
            return modelAndView;
        }
        response.sendError(404, "Job not found");
        return null;
    }

    @RequestMapping(value={"/internal/jobs/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public JobRepresentation getJob(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.setCorsHeaders(response);
        Optional<JobInfo> optionalJob = this.jobService.findJob(this.jobUriOf(request));
        if (optionalJob.isPresent()) {
            return JobRepresentation.representationOf(optionalJob.get(), false, UrlHelper.baseUriOf(request));
        }
        response.sendError(404, "Job not found");
        return null;
    }

    private void setCorsHeaders(HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Methods", "GET");
        response.setHeader("Access-Control-Allow-Origin", "*");
    }

    private URI jobUriOf(HttpServletRequest request) {
        String servletPath;
        String string = servletPath = request.getServletPath() != null ? request.getServletPath() : "";
        if (servletPath.contains(".")) {
            return URI.create(servletPath.substring(0, servletPath.lastIndexOf(46)));
        }
        return URI.create(servletPath);
    }
}

