/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.controller;

import de.otto.edison.jobs.controller.Link;
import de.otto.edison.jobs.domain.JobInfo;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class JobRepresentation {
    private final JobInfo job;
    private final boolean humanReadable;
    private final String baseUri;

    private JobRepresentation(JobInfo job, boolean humanReadable, String baseUri) {
        this.job = job;
        this.humanReadable = humanReadable;
        this.baseUri = baseUri;
    }

    public static JobRepresentation representationOf(JobInfo job, boolean humanReadable, String baseUri) {
        return new JobRepresentation(job, humanReadable, baseUri);
    }

    public String getJobUri() {
        return this.baseUri + this.job.getJobUri().toString();
    }

    public String getJobType() {
        return this.job.getJobType();
    }

    public String getStatus() {
        return this.job.getStatus().name();
    }

    public String getState() {
        return this.job.getState();
    }

    public String getStarted() {
        OffsetDateTime started = this.job.getStarted();
        return this.formatDateTime(started);
    }

    public String getStopped() {
        return this.job.isStopped() ? this.formatTime(this.job.getStopped().get()) : "";
    }

    public String getLastUpdated() {
        return this.formatTime(this.job.getLastUpdated());
    }

    public List<String> getMessages() {
        return this.job.getMessages().stream().map(jobMessage -> "[" + this.formatTime(jobMessage.getTimestamp()) + "] [" + jobMessage.getLevel().getKey() + "] " + jobMessage.getMessage()).collect(Collectors.toList());
    }

    public List<Link> getLinks() {
        String jobUri = this.baseUri + this.job.getJobUri().toString();
        return Arrays.asList(Link.link("self", jobUri, "Self"), Link.link("http://github.com/otto-de/edison/link-relations/job/definition", this.baseUri + "/internal/jobdefinitions/" + this.job.getJobType(), "Job Definition"), Link.link("collection", jobUri.substring(0, jobUri.lastIndexOf("/")), "All Jobs"), Link.link("collection/" + this.getJobType(), jobUri.substring(0, jobUri.lastIndexOf("/")) + "?type=" + this.getJobType(), "All " + this.getJobType() + " Jobs"));
    }

    private String formatDateTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return this.humanReadable ? DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.MEDIUM).format(dateTime) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
    }

    private String formatTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return this.humanReadable ? DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).format(dateTime) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRepresentation that = (JobRepresentation)o;
        return !(this.job != null ? !this.job.equals(that.job) : that.job != null);
    }

    public int hashCode() {
        return this.job != null ? this.job.hashCode() : 0;
    }

    public String toString() {
        return "JobRepresentation{job=" + this.job + '}';
    }
}

