/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.controller;

import de.otto.edison.jobs.controller.JobDefinitionRepresentation;
import de.otto.edison.jobs.controller.Link;
import de.otto.edison.jobs.controller.UrlHelper;
import de.otto.edison.jobs.definition.JobDefinition;
import de.otto.edison.jobs.service.JobDefinitionService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class JobDefinitionsController {
    private static final Logger LOG = LoggerFactory.getLogger(JobDefinitionsController.class);
    public static final String INTERNAL_JOBDEFINITIONS = "/internal/jobdefinitions";
    @Autowired
    private JobDefinitionService jobDefinitions;

    public JobDefinitionsController() {
    }

    public JobDefinitionsController(JobDefinitionService service) {
        this.jobDefinitions = service;
    }

    @RequestMapping(value={"/internal/jobdefinitions"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<Link>> getJobDefinitionsAsJson(final HttpServletRequest request) {
        final String baseUri = UrlHelper.baseUriOf(request);
        return Collections.singletonMap("links", new ArrayList<Link>(){
            {
                this.addAll(JobDefinitionsController.this.jobDefinitions.getJobDefinitions().stream().map(def -> Link.link("http://github.com/otto-de/edison/link-relations/job/definition", baseUri + JobDefinitionsController.INTERNAL_JOBDEFINITIONS + "/" + def.jobType(), def.jobName())).collect(Collectors.toList()));
                this.add(Link.link("self", UrlHelper.baseUriOf(request) + JobDefinitionsController.INTERNAL_JOBDEFINITIONS, "Self"));
            }
        });
    }

    @RequestMapping(value={"/internal/jobdefinitions"}, method={RequestMethod.GET}, produces={"*/*"})
    public ModelAndView getJobDefinitionsAsHtml(final HttpServletRequest request) {
        return new ModelAndView("jobdefinitions", (Map)new HashMap<String, Object>(){
            {
                this.put("baseUri", UrlHelper.baseUriOf(request));
                this.put("jobdefinitions", JobDefinitionsController.this.jobDefinitions.getJobDefinitions().stream().map(def -> new HashMap<String, Object>(){
                    {
                        this.put("jobType", def.jobType());
                        this.put("name", def.jobName());
                        this.put("description", def.description());
                        this.put("maxAge", def.maxAge().isPresent() ? def.maxAge().get().toMinutes() + " Minutes" : "unlimited");
                        this.put("frequency", JobDefinitionsController.this.frequencyOf(def));
                        this.put("retry", JobDefinitionsController.this.retryOf(def));
                    }
                }).collect(Collectors.toList()));
            }
        });
    }

    @RequestMapping(value={"/internal/jobdefinitions/{jobType}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JobDefinitionRepresentation getJobDefinition(@PathVariable String jobType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional<JobDefinition> jobDefinition = this.jobDefinitions.getJobDefinition(jobType);
        if (jobDefinition.isPresent()) {
            return JobDefinitionRepresentation.representationOf(jobDefinition.get(), UrlHelper.baseUriOf(request));
        }
        response.sendError(404, "Job not found");
        return null;
    }

    @RequestMapping(value={"/internal/jobdefinitions/{jobType}"}, method={RequestMethod.GET}, produces={"*/*"})
    public ModelAndView getJobDefinitionAsHtml(@PathVariable String jobType, HttpServletRequest request, HttpServletResponse response) throws IOException {
        final Optional<HashMap> optionalResult = this.jobDefinitions.getJobDefinition(jobType).map(def -> new HashMap<String, Object>(){
            {
                this.put("jobType", def.jobType());
                this.put("name", def.jobName());
                this.put("description", def.description());
                this.put("maxAge", def.maxAge().isPresent() ? def.maxAge().get().toMinutes() + " Minutes" : "unlimited");
                this.put("frequency", JobDefinitionsController.this.frequencyOf(def));
                this.put("retry", JobDefinitionsController.this.retryOf(def));
            }
        });
        if (optionalResult.isPresent()) {
            return new ModelAndView("jobdefinition", (Map)new HashMap<String, Object>(){
                {
                    this.put("def", optionalResult.get());
                }
            });
        }
        response.sendError(404, "JobDefinition " + jobType + " not found.");
        return null;
    }

    private String frequencyOf(JobDefinition def) {
        return def.cron().isPresent() ? def.cron().get() : "Every " + def.fixedDelay().get().toMinutes() + " Minutes";
    }

    private String retryOf(JobDefinition def) {
        String delay = def.retryDelay().isPresent() ? " with " + def.retryDelay().get().getSeconds() + " seconds delay." : ".";
        return def.retries() == 0 ? "Do not retry triggering" : "Retry trigger " + def.retries() + " times" + delay;
    }
}

