/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.otto.edison.jobs.controller.Link;
import de.otto.edison.jobs.definition.JobDefinition;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobDefinitionRepresentation {
    public final String type;
    public final String name;
    public final int retries;
    public final Long retryDelay;
    public final String cron;
    public final Long maxAge;
    public final Long fixedDelay;
    public final List<Link> links;

    private JobDefinitionRepresentation(JobDefinition jobDefinition, String baseUri) {
        this.type = jobDefinition.jobType();
        this.name = jobDefinition.jobName();
        this.retries = jobDefinition.retries();
        this.retryDelay = this.valueOf(jobDefinition.retryDelay());
        this.cron = jobDefinition.cron().orElse(null);
        this.maxAge = this.valueOf(jobDefinition.maxAge());
        this.fixedDelay = this.valueOf(jobDefinition.fixedDelay());
        this.links = this.linksOf(jobDefinition, baseUri);
    }

    public static JobDefinitionRepresentation representationOf(JobDefinition jobDefinition, String baseUri) {
        return new JobDefinitionRepresentation(jobDefinition, baseUri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobDefinitionRepresentation that = (JobDefinitionRepresentation)o;
        if (this.retries != that.retries) {
            return false;
        }
        if (this.cron != null ? !this.cron.equals(that.cron) : that.cron != null) {
            return false;
        }
        if (this.fixedDelay != null ? !this.fixedDelay.equals(that.fixedDelay) : that.fixedDelay != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        if (this.maxAge != null ? !this.maxAge.equals(that.maxAge) : that.maxAge != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.retryDelay != null ? !this.retryDelay.equals(that.retryDelay) : that.retryDelay != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.retries;
        result = 31 * result + (this.retryDelay != null ? this.retryDelay.hashCode() : 0);
        result = 31 * result + (this.cron != null ? this.cron.hashCode() : 0);
        result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
        result = 31 * result + (this.fixedDelay != null ? this.fixedDelay.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JobDefinitionRepresentation{cron='" + this.cron + '\'' + ", type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", retries=" + this.retries + ", retryDelay=" + this.retryDelay + ", maxAge=" + this.maxAge + ", fixedDelay=" + this.fixedDelay + ", links=" + this.links + '}';
    }

    private List<Link> linksOf(JobDefinition jobDefinition, String baseUri) {
        return Arrays.asList(Link.link("self", baseUri + "/internal/jobsdefinitions/" + jobDefinition.jobType(), null), Link.link("collection", baseUri + "/internal/jobdefinitions", null), Link.link("http://github.com/otto-de/edison/link-relations/job/trigger", baseUri + "/internal/jobs/" + jobDefinition.jobType(), null));
    }

    private Long valueOf(Optional<Duration> duration) {
        if (duration.isPresent()) {
            return duration.get().getSeconds();
        }
        return null;
    }
}

