/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.configuration;

import de.otto.edison.jobs.definition.JobDefinition;
import de.otto.edison.jobs.monitor.JobMonitor;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.repository.cleanup.KeepLastJobs;
import de.otto.edison.jobs.repository.cleanup.StopDeadJobs;
import de.otto.edison.jobs.repository.inmem.InMemJobRepository;
import de.otto.edison.jobs.service.DefaultJobService;
import de.otto.edison.jobs.service.JobDefinitionService;
import de.otto.edison.jobs.service.JobService;
import de.otto.edison.jobs.status.JobStatusDetailIndicator;
import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.CompositeStatusDetailIndicator;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableAsync
@EnableScheduling
public class JobConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(JobConfiguration.class);
    @Value(value="${edison.jobs.scheduler.thread-count:10}")
    int numberOfThreads;
    @Value(value="${edison.jobs.cleanup.number-to-keep:100}")
    int numberOfJobsToKeep;
    @Value(value="${edison.jobs.cleanup.mark-dead-after:20}")
    int secondsToMarkJobsAsDead;

    @Bean
    @ConditionalOnMissingBean(value={ScheduledExecutorService.class})
    public ScheduledExecutorService scheduledExecutorService() {
        return Executors.newScheduledThreadPool(this.numberOfThreads);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobRepository.class})
    public JobRepository jobRepository() {
        LOG.warn("Using in-memory JobRepository");
        return new InMemJobRepository();
    }

    @Bean
    @ConditionalOnMissingBean(value={JobService.class})
    public JobService jobService() {
        return new DefaultJobService();
    }

    @Bean
    @ConditionalOnMissingBean(value={KeepLastJobs.class})
    public KeepLastJobs keepLastJobsStrategy() {
        return new KeepLastJobs(this.numberOfJobsToKeep, Optional.empty());
    }

    @Bean
    @ConditionalOnMissingBean(value={StopDeadJobs.class})
    public StopDeadJobs deadJobStrategy() {
        return new StopDeadJobs(this.secondsToMarkJobsAsDead, Clock.systemDefaultZone());
    }

    @Bean
    @ConditionalOnMissingBean(value={JobMonitor.class})
    public JobMonitor jobMonitor() {
        return jobInfo -> {};
    }

    @Bean
    @ConditionalOnProperty(name={"edison.jobs.status.enabled"}, havingValue="true", matchIfMissing=true)
    public StatusDetailIndicator jobStatusDetailIndicator(JobDefinitionService service) {
        List<JobDefinition> jobDefinitions = service.getJobDefinitions();
        if (jobDefinitions.isEmpty()) {
            return () -> StatusDetail.statusDetail((String)"jobs", (Status)Status.OK, (String)"No job definitions configured in application.");
        }
        return new CompositeStatusDetailIndicator("jobs", jobDefinitions.stream().map(d -> new JobStatusDetailIndicator(this.jobRepository(), d.jobName(), d.jobType(), d.maxAge())).collect(Collectors.toList()));
    }
}

