/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.status;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JobStatusDetailIndicator
implements StatusDetailIndicator {
    public static final String SUCCESS_MESSAGE = "Last job was successful";
    public static final String ERROR_MESSAGE = "Job had an error";
    public static final String JOB_TOO_OLD_MESSAGE = "Job didn't run in the past ";
    private final JobRepository jobRepository;
    private final String name;
    private final String jobType;
    private final String baseUrl;
    private final Duration maxAge;

    public JobStatusDetailIndicator(JobRepository jobRepository, String name, String jobType, String baseUrl, Duration maxAge) {
        this.jobRepository = jobRepository;
        this.name = name;
        this.jobType = jobType;
        this.baseUrl = baseUrl;
        this.maxAge = maxAge;
    }

    public StatusDetail statusDetail() {
        List<JobInfo> jobs = this.jobRepository.findLatestBy(this.jobType, 1);
        return jobs.isEmpty() ? this.statusDetailWhenNoJobAvailable() : this.toStatusDetail(jobs.get(0));
    }

    private StatusDetail toStatusDetail(JobInfo jobInfo) {
        String message;
        Status status;
        if (JobInfo.JobStatus.OK.equals((Object)jobInfo.getStatus()) && this.jobTooOld(jobInfo)) {
            status = Status.WARNING;
            message = JOB_TOO_OLD_MESSAGE + this.maxAge;
        } else if (JobInfo.JobStatus.OK.equals((Object)jobInfo.getStatus())) {
            status = Status.OK;
            message = SUCCESS_MESSAGE;
        } else {
            status = Status.WARNING;
            message = ERROR_MESSAGE;
        }
        return StatusDetail.statusDetail((String)this.name, (Status)status, (String)message, this.runningDetailsFor(jobInfo));
    }

    private StatusDetail statusDetailWhenNoJobAvailable() {
        return StatusDetail.statusDetail((String)this.name, (Status)Status.OK, (String)SUCCESS_MESSAGE);
    }

    private Map<String, String> runningDetailsFor(JobInfo jobInfo) {
        HashMap<String, String> details = new HashMap<String, String>();
        String uri = this.baseUrl + jobInfo.getJobUri().toString();
        details.put("uri", uri);
        if (!jobInfo.getStopped().isPresent()) {
            details.put("running", uri);
        }
        return details;
    }

    private boolean jobTooOld(JobInfo jobInfo) {
        Optional<OffsetDateTime> stopped = jobInfo.getStopped();
        if (stopped.isPresent()) {
            OffsetDateTime deadlineToRerun = stopped.get().plus(this.maxAge);
            return deadlineToRerun.isBefore(OffsetDateTime.now());
        }
        return false;
    }
}

