/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.domain;

import de.otto.edison.jobs.domain.Level;
import java.time.OffsetDateTime;

public final class JobMessage {
    private final Level level;
    private final String message;
    private final OffsetDateTime timestamp;

    private JobMessage(Level level, String message, OffsetDateTime timestamp) {
        this.level = level;
        this.message = message;
        this.timestamp = timestamp;
    }

    public static JobMessage jobMessage(Level level, String message) {
        return new JobMessage(level, message, OffsetDateTime.now());
    }

    public static JobMessage jobMessage(Level level, String message, OffsetDateTime ts) {
        return new JobMessage(level, message, ts);
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobMessage that = (JobMessage)o;
        if (this.level != that.level) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return !(this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null);
    }

    public int hashCode() {
        int result = this.level != null ? this.level.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JobMessage{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + ", timestamp=" + this.timestamp + '}';
    }
}

