/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.configuration;

import de.otto.edison.jobs.monitor.JobMonitor;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.repository.cleanup.KeepLastJobs;
import de.otto.edison.jobs.repository.cleanup.StopDeadJobs;
import de.otto.edison.jobs.repository.inmem.InMemJobRepository;
import de.otto.edison.jobs.service.DefaultJobService;
import de.otto.edison.jobs.service.JobService;
import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableAsync
@EnableScheduling
public class JobConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(JobConfiguration.class);
    @Value(value="${edison.jobs.scheduler.thread-count:10}")
    int numberOfThreads;
    @Value(value="${edison.jobs.cleanup.number-to-keep:100}")
    int numberOfJobsToKeep;
    @Value(value="${edison.jobs.cleanup.mark-dead-after:20}")
    int secondsToMarkJobsAsDead;

    @Bean
    @ConditionalOnMissingBean(value={ScheduledExecutorService.class})
    public ScheduledExecutorService scheduledExecutorService() {
        return Executors.newScheduledThreadPool(this.numberOfThreads);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobRepository.class})
    public JobRepository inMemJobRepository() {
        LOG.warn("Using in-memory JobRepository");
        return new InMemJobRepository();
    }

    @Bean
    @ConditionalOnMissingBean(value={JobService.class})
    public JobService jobService() {
        return new DefaultJobService();
    }

    @Bean
    @ConditionalOnMissingBean(value={KeepLastJobs.class})
    public KeepLastJobs keepLastJobsStrategy() {
        return new KeepLastJobs(this.numberOfJobsToKeep, Optional.empty());
    }

    @Bean
    @ConditionalOnMissingBean(value={StopDeadJobs.class})
    public StopDeadJobs deadJobStrategy() {
        return new StopDeadJobs(this.secondsToMarkJobsAsDead, Clock.systemDefaultZone());
    }

    @Bean
    @ConditionalOnMissingBean(value={JobMonitor.class})
    public JobMonitor jobMonitor() {
        return jobInfo -> {};
    }
}

