/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.service;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.service.JobRunnable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(JobRunner.class);
    public static final long PING_PERIOD = 1L;
    private volatile JobInfo jobInfo;
    private final JobRepository jobRepository;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> pingJob;

    private JobRunner(JobInfo jobInfo, JobRepository jobRepository, ScheduledExecutorService executorService) {
        this.jobInfo = jobInfo;
        this.jobRepository = jobRepository;
        this.executorService = executorService;
    }

    public static JobRunner newJobRunner(JobInfo job, JobRepository jobRepository, ScheduledExecutorService executorService) {
        return new JobRunner(job, jobRepository, executorService);
    }

    public void start(JobRunnable runnable) {
        this.start();
        try {
            runnable.execute(this.jobInfo);
        }
        catch (RuntimeException e) {
            this.error(e);
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            this.jobRepository.createOrUpdate(this.jobInfo);
            this.pingJob = this.executorService.scheduleAtFixedRate(this::ping, 1L, 1L, TimeUnit.SECONDS);
            String jobId = this.jobInfo.getJobUri().toString();
            MDC.put((String)"job_id", (String)jobId.substring(jobId.lastIndexOf(47) + 1));
            MDC.put((String)"job_type", (String)this.jobInfo.getJobType());
            LOG.info("[started]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ping() {
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            this.jobInfo.ping();
            this.jobRepository.createOrUpdate(this.jobInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(Exception e) {
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            assert (!this.jobInfo.isStopped());
            this.jobInfo.error(e.getMessage());
            this.jobRepository.createOrUpdate(this.jobInfo);
            LOG.error("Fatal error in job " + this.jobInfo.getJobType() + " (" + this.jobInfo.getJobUri() + ")", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        JobRunner jobRunner = this;
        synchronized (jobRunner) {
            this.pingJob.cancel(false);
            assert (!this.jobInfo.isStopped());
            try {
                LOG.info("stopped job {}", (Object)this.jobInfo);
                this.jobInfo.stop();
                this.jobRepository.createOrUpdate(this.jobInfo);
            }
            finally {
                MDC.clear();
            }
        }
    }
}

