/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.controller;

import de.otto.edison.jobs.controller.JobRepresentation;
import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.service.JobService;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class JobsController {
    private static final Logger LOG = LoggerFactory.getLogger(JobsController.class);
    public static final int JOB_VIEW_COUNT = 100;
    @Autowired
    private JobService jobService;
    @Value(value="${server.contextPath}")
    private String serverContextPath;

    public JobsController() {
    }

    JobsController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/internal/jobs"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView getJobsAsHtml(@RequestParam(value="type", required=false) String type) {
        List jobRepresentations = this.jobService.findJobs(Optional.ofNullable(type), 100).stream().map(j -> JobRepresentation.representationOf(j, true)).collect(Collectors.toList());
        ModelAndView modelAndView = new ModelAndView("jobs");
        modelAndView.addObject("jobs", jobRepresentations);
        return modelAndView;
    }

    @RequestMapping(value={"/internal/jobs"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<JobRepresentation> getJobsAsJson(@RequestParam(value="type", required=false) String type, @RequestParam(value="count", defaultValue="1") int count) {
        return this.jobService.findJobs(Optional.ofNullable(type), count).stream().map(j -> JobRepresentation.representationOf(j, false)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/internal/jobs"}, method={RequestMethod.DELETE})
    public void deleteJobs(@RequestParam(value="type", required=false) String type) {
        this.jobService.deleteJobs(Optional.ofNullable(type));
    }

    @RequestMapping(value={"/internal/jobs/{jobType}"}, method={RequestMethod.POST})
    public void startJob(@PathVariable String jobType, HttpServletResponse response) throws IOException {
        URI jobUri = this.jobService.startAsyncJob(jobType);
        response.setHeader("Location", jobUri.toString());
        response.setStatus(204);
    }

    @RequestMapping(value={"/internal/jobs/{id}"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView findJobAsHtml(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = URI.create(request.getRequestURI());
        Optional<JobInfo> optionalJob = this.jobService.findJob(uri);
        if (optionalJob.isPresent()) {
            ModelAndView modelAndView = new ModelAndView("job");
            modelAndView.addObject("job", (Object)JobRepresentation.representationOf(optionalJob.get(), true));
            return modelAndView;
        }
        response.sendError(404, "Job not found");
        return null;
    }

    @RequestMapping(value={"/internal/jobs/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public JobRepresentation findJob(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = URI.create(request.getRequestURI());
        Optional<JobInfo> optionalJob = this.jobService.findJob(uri);
        if (optionalJob.isPresent()) {
            return JobRepresentation.representationOf(optionalJob.get(), false);
        }
        response.sendError(404, "Job not found");
        return null;
    }
}

