/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.controller;

import de.otto.edison.jobs.domain.JobInfo;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.stream.Collectors;

public class JobRepresentation {
    private final JobInfo job;
    private final boolean humanReadable;

    private JobRepresentation(JobInfo job, boolean humanReadable) {
        this.job = job;
        this.humanReadable = humanReadable;
    }

    public static JobRepresentation representationOf(JobInfo job, boolean humanReadable) {
        return new JobRepresentation(job, humanReadable);
    }

    public String getJobUri() {
        return this.job.getJobUri().toString();
    }

    public String getJobType() {
        return this.job.getJobType();
    }

    public String getStatus() {
        return this.job.getStatus().name();
    }

    public String getState() {
        return this.job.getState();
    }

    public String getStarted() {
        OffsetDateTime started = this.job.getStarted();
        return this.formatDateTime(started);
    }

    public String getStopped() {
        return this.job.isStopped() ? this.formatTime(this.job.getStopped().get()) : "";
    }

    public String getLastUpdated() {
        return this.formatTime(this.job.getLastUpdated());
    }

    public List<String> getMessages() {
        return this.job.getMessages().stream().map(jobMessage -> "[" + this.formatTime(jobMessage.getTimestamp()) + "] [" + jobMessage.getLevel().getKey() + "] " + jobMessage.getMessage()).collect(Collectors.toList());
    }

    private String formatDateTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return this.humanReadable ? DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT, FormatStyle.MEDIUM).format(dateTime) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
    }

    private String formatTime(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return this.humanReadable ? DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).format(dateTime) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRepresentation that = (JobRepresentation)o;
        return !(this.job != null ? !this.job.equals(that.job) : that.job != null);
    }

    public int hashCode() {
        return this.job != null ? this.job.hashCode() : 0;
    }

    public String toString() {
        return "JobRepresentation{job=" + this.job + '}';
    }
}

