/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import de.otto.edison.vault.ConfigProperties;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class VaultTokenReader {
    private static final Logger LOG = LoggerFactory.getLogger(VaultTokenReader.class);
    private final AsyncHttpClient asyncHttpClient;

    public VaultTokenReader(AsyncHttpClient asyncHttpClient) {
        this.asyncHttpClient = asyncHttpClient;
    }

    public String readVaultToken(ConfigProperties configProperties) {
        if (configProperties.getTokenSource() == null) {
            throw new IllegalArgumentException("tokenSource not set");
        }
        switch (configProperties.getTokenSource()) {
            case "login": {
                return this.readTokenFromLogin(configProperties.getBaseUrl(), configProperties.getAppId(), configProperties.getUserId());
            }
            case "file": {
                String fileToken = configProperties.getFileToken();
                if (StringUtils.isEmpty((Object)fileToken)) {
                    fileToken = configProperties.getDefaultVaultTokenFileName();
                }
                return this.readTokenFromFile(fileToken);
            }
            case "environment": {
                return this.readTokenFromEnv(configProperties.getEnvironmentToken());
            }
        }
        throw new IllegalArgumentException("tokenSource is undefined");
    }

    protected String readTokenFromFile(String fileName) {
        try {
            File tokenFile = new File(fileName);
            if (!tokenFile.exists() || !tokenFile.canRead()) {
                throw new RuntimeException(String.format("Can not read tokenfile from %s", fileName));
            }
            return new String(Files.readAllBytes(Paths.get(fileName, new String[0])), "UTF-8").replaceAll("\\s+", "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String readTokenFromEnv(String env) {
        return System.getenv(env);
    }

    public String readTokenFromLogin(String vaultBaseUrl, String appId, String userId) {
        try {
            Response response = (Response)this.asyncHttpClient.preparePost(vaultBaseUrl + "/v1/auth/app-id/login").setBody(VaultTokenReader.createAuthBody(appId, userId)).execute().get();
            if (response.getStatusCode() != 200) {
                throw new RuntimeException("login to vault failed, return code is " + response.getStatusCode());
            }
            LOG.info("login to vault successful");
            return VaultTokenReader.extractToken(response.getResponseBody());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.error("could not retrieve token from vault", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String createAuthBody(String appId, String userId) {
        return String.format("{\"app_id\":\"%s\", \"user_id\": \"%s\"}", appId, userId);
    }

    private static String extractToken(String responseBody) {
        Map responseMap = (Map)new Gson().fromJson(responseBody, Map.class);
        Map auth = (Map)responseMap.get("auth");
        return (String)auth.get("client_token");
    }
}

