/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import de.otto.edison.vault.ConfigProperties;
import de.otto.edison.vault.VaultPropertySource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="edison.vault", name={"enableconfigurer"}, matchIfMissing=true)
public class VaultPropertySourcePostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private ConfigProperties configProperties;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurableEnvironment env = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        MutablePropertySources propertySources = env.getPropertySources();
        propertySources.addLast((PropertySource)new VaultPropertySource("vaultPropertySource", this.configProperties));
    }

    public void setEnvironment(Environment environment) {
        this.configProperties = new ConfigProperties(environment);
    }
}

