/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import com.ning.http.client.AsyncHttpClient;
import de.otto.edison.vault.ConfigProperties;
import de.otto.edison.vault.VaultClient;
import de.otto.edison.vault.VaultTokenReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MapPropertySource;

public class VaultPropertySource
extends MapPropertySource {
    private static final Logger LOG = LoggerFactory.getLogger(VaultPropertySource.class);

    public VaultPropertySource(String name, ConfigProperties configProperties) {
        super(name, new HashMap());
        if (configProperties.isEnabled()) {
            this.loadPropertiesFromVault(this.createVaultClient(configProperties), configProperties.getProperties());
        }
    }

    protected VaultClient createVaultClient(ConfigProperties configProperties) {
        return VaultClient.vaultClient(configProperties, new VaultTokenReader(new AsyncHttpClient()).readVaultToken(configProperties));
    }

    private void loadPropertiesFromVault(VaultClient vaultClient, Set<String> properties) {
        properties.stream().map(VaultFieldInfo::new).collect(Collectors.groupingBy(VaultFieldInfo::getVaultSecretPathName)).forEach((vaultSecretPath, fields) -> {
            Map<String, String> vaultFieldValues = vaultClient.readFields((String)vaultSecretPath);
            fields.forEach(field -> {
                String vaultFieldValue = (String)vaultFieldValues.get(field.getVaultFieldName());
                if (vaultFieldValue == null) {
                    throw new RuntimeException("unable read value '" + field.getVaultFieldName() + "' from vault property '" + field.getVaultSecretPathName() + "' - value not found");
                }
                LOG.info("read of value '{}' from vault property '{}' successful", (Object)field.getVaultFieldName(), (Object)field.getVaultSecretPathName());
                ((Map)this.source).put(field.getSpringPropertyPath(), vaultFieldValue);
            });
        });
    }

    private static class VaultFieldInfo {
        private final String vaultSecretPathName;
        private final String vaultFieldName;
        private final String springPropertyPath;

        VaultFieldInfo(String springPropertyPath) {
            int lastDotIndex = springPropertyPath.lastIndexOf(".");
            if (lastDotIndex >= 0) {
                this.vaultSecretPathName = springPropertyPath.substring(0, lastDotIndex).replace(".", "/");
                this.vaultFieldName = springPropertyPath.substring(lastDotIndex + 1);
            } else {
                this.vaultSecretPathName = "";
                this.vaultFieldName = springPropertyPath;
            }
            this.springPropertyPath = springPropertyPath;
        }

        String getVaultSecretPathName() {
            return this.vaultSecretPathName;
        }

        String getVaultFieldName() {
            return this.vaultFieldName;
        }

        String getSpringPropertyPath() {
            return this.springPropertyPath;
        }
    }
}

