/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ConfigProperties {
    private final boolean enabled;
    private final String baseUrl;
    private final String secretPath;
    private final Set<String> properties;
    private final String tokenSource;
    private final String environmentToken;
    private final String fileToken;
    private final String appId;
    private final String userId;
    private final String defaultVaultToken;

    public ConfigProperties(Environment environment) {
        this.enabled = Boolean.parseBoolean(environment.getProperty("edison.vault.enabled"));
        String baseUrlProperty = environment.getProperty("edison.vault.base-url");
        this.baseUrl = StringUtils.isEmpty((Object)baseUrlProperty) ? ConfigProperties.getVaultAddrFromEnv() : baseUrlProperty;
        this.secretPath = environment.getProperty("edison.vault.secret-path");
        this.properties = this.splitVaultPropertyKeys(environment.getProperty("edison.vault.properties"));
        this.tokenSource = environment.getProperty("edison.vault.token-source");
        this.environmentToken = environment.getProperty("edison.vault.environment-token");
        this.fileToken = environment.getProperty("edison.vault.file-token");
        this.appId = environment.getProperty("edison.vault.appid");
        this.userId = environment.getProperty("edison.vault.userid");
        String homeDir = environment.getProperty("user.home");
        this.defaultVaultToken = homeDir + "/.vault-token";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getSecretPath() {
        return this.secretPath;
    }

    public Set<String> getProperties() {
        return this.properties;
    }

    public String getTokenSource() {
        return this.tokenSource;
    }

    public String getEnvironmentToken() {
        return this.environmentToken;
    }

    public String getFileToken() {
        return this.fileToken;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getDefaultVaultTokenFileName() {
        return this.defaultVaultToken;
    }

    private static String getVaultAddrFromEnv() {
        return System.getenv("VAULT_ADDR");
    }

    private Set<String> splitVaultPropertyKeys(String properties) {
        if (StringUtils.isEmpty((Object)properties)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(Arrays.stream(properties.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigProperties that = (ConfigProperties)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.baseUrl != null ? !this.baseUrl.equals(that.baseUrl) : that.baseUrl != null) {
            return false;
        }
        if (this.secretPath != null ? !this.secretPath.equals(that.secretPath) : that.secretPath != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.tokenSource != null ? !this.tokenSource.equals(that.tokenSource) : that.tokenSource != null) {
            return false;
        }
        if (this.environmentToken != null ? !this.environmentToken.equals(that.environmentToken) : that.environmentToken != null) {
            return false;
        }
        if (this.fileToken != null ? !this.fileToken.equals(that.fileToken) : that.fileToken != null) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(that.appId) : that.appId != null) {
            return false;
        }
        if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
            return false;
        }
        return this.defaultVaultToken != null ? this.defaultVaultToken.equals(that.defaultVaultToken) : that.defaultVaultToken == null;
    }

    public int hashCode() {
        int result = this.enabled ? 1 : 0;
        result = 31 * result + (this.baseUrl != null ? this.baseUrl.hashCode() : 0);
        result = 31 * result + (this.secretPath != null ? this.secretPath.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.tokenSource != null ? this.tokenSource.hashCode() : 0);
        result = 31 * result + (this.environmentToken != null ? this.environmentToken.hashCode() : 0);
        result = 31 * result + (this.fileToken != null ? this.fileToken.hashCode() : 0);
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + (this.defaultVaultToken != null ? this.defaultVaultToken.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConfigProperties{enabled=" + this.enabled + ", baseUrl='" + this.baseUrl + '\'' + ", secretPath='" + this.secretPath + '\'' + ", properties=" + this.properties + ", tokenSource='" + this.tokenSource + '\'' + ", environmentToken='" + this.environmentToken + '\'' + ", fileToken='" + this.fileToken + '\'' + ", appId='" + this.appId + '\'' + ", userId='" + this.userId + '\'' + ", defaultVaultToken='" + this.defaultVaultToken + '\'' + '}';
    }
}

