/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultToken {
    private Logger LOG = LoggerFactory.getLogger(VaultToken.class);
    protected AsyncHttpClient asyncHttpClient = new AsyncHttpClient();
    protected String token;

    protected void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void readTokenFromFile(String fileName) {
        try {
            File tokenFile = new File(fileName);
            if (!tokenFile.exists() || !tokenFile.canRead()) {
                throw new RuntimeException(String.format("Can not read tokenfile from %s", fileName));
            }
            this.token = new String(Files.readAllBytes(Paths.get(fileName, new String[0])), "UTF-8").replaceAll("\\s+", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readTokenFromEnv(String env) {
        this.token = System.getenv(env);
    }

    public void readTokenFromLogin(String vaultBaseUrl, String appId, String userId) {
        try {
            Response response = (Response)this.asyncHttpClient.preparePost(vaultBaseUrl + "/v1/auth/app-id/login").setBody(this.createAuthBody(appId, userId)).execute().get();
            if (response.getStatusCode() != 200) {
                throw new RuntimeException("login to vault failed, return code is " + response.getStatusCode());
            }
            this.LOG.info("login to vault successful");
            this.token = this.extractToken(response.getResponseBody());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.token = null;
            this.LOG.error("could not retrieve token from vault", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String createAuthBody(String appId, String userId) {
        return String.format("{\"app_id\":\"%s\", \"user_id\": \"%s\"}", appId, userId);
    }

    private String extractToken(String responseBody) {
        Map responseMap = (Map)new Gson().fromJson(responseBody, Map.class);
        Map auth = (Map)responseMap.get("auth");
        return (String)auth.get("client_token");
    }
}

