/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import de.otto.edison.vault.VaultPropertiesReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="edison.vault", name={"enableconfigurer"}, matchIfMissing=true)
public class VaultPropertyPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer {
    protected Environment environment;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        VaultPropertiesReader vaultPropertiesReader = new VaultPropertiesReader(this.environment);
        if (vaultPropertiesReader.vaultEnabled()) {
            this.setProperties(vaultPropertiesReader.fetchPropertiesFromVault());
        }
        super.postProcessBeanFactory(beanFactory);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        super.setEnvironment(environment);
    }
}

