/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import de.otto.edison.vault.VaultClient;
import de.otto.edison.vault.VaultToken;
import de.otto.edison.vault.VaultTokenFactory;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class VaultPropertiesReader {
    private final Environment environment;
    private Logger LOG = LoggerFactory.getLogger(VaultPropertiesReader.class);
    protected VaultTokenFactory vaultTokenFactory = new VaultTokenFactory();

    public VaultPropertiesReader(Environment environment) {
        this.environment = environment;
    }

    public boolean vaultEnabled() {
        String vaultEnabled = this.environment.getProperty("edison.vault.enabled");
        return vaultEnabled != null && Boolean.parseBoolean(vaultEnabled);
    }

    protected VaultClient getVaultClient() {
        String vaultSecretPath = this.environment.getProperty("edison.vault.secret-path");
        String tokenEnvironment = this.environment.getProperty("edison.vault.environment-token");
        String tokenFile = this.environment.getProperty("edison.vault.file-token");
        String vaultAppId = this.environment.getProperty("edison.vault.appid");
        String vaultUserId = this.environment.getProperty("edison.vault.userid");
        String vaultBaseUrl = this.environment.getProperty("edison.vault.base-url");
        if (StringUtils.isEmpty((Object)vaultBaseUrl)) {
            vaultBaseUrl = VaultClient.getVaultAddrFromEnv();
        }
        VaultToken vaultToken = this.vaultTokenFactory.createVaultToken();
        if (!StringUtils.isEmpty((Object)tokenEnvironment)) {
            this.LOG.info("read token from env variable '{}'", (Object)tokenEnvironment);
            vaultToken.readTokenFromEnv(tokenEnvironment);
        } else if (!StringUtils.isEmpty((Object)tokenFile)) {
            this.LOG.info("read token from file '{}'", (Object)tokenFile);
            vaultToken.readTokenFromFile(tokenFile);
        } else {
            this.LOG.info("get token from login");
            vaultToken.readTokenFromLogin(vaultBaseUrl, vaultAppId, vaultUserId);
        }
        return VaultClient.vaultClient(vaultBaseUrl, vaultSecretPath, vaultToken);
    }

    public Properties fetchPropertiesFromVault() {
        Properties vaultProperties = new Properties();
        VaultClient vaultClient = this.getVaultClient();
        for (String key : this.fetchVaultPropertyKeys()) {
            String trimmedKey = key.trim();
            vaultProperties.setProperty(trimmedKey, vaultClient.read(trimmedKey));
        }
        return vaultProperties;
    }

    private String[] fetchVaultPropertyKeys() {
        String vaultPropertyKeys = this.environment.getProperty("edison.vault.properties");
        if (StringUtils.isEmpty((Object)vaultPropertyKeys)) {
            return new String[0];
        }
        return vaultPropertyKeys.split(",");
    }
}

