/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.vault;

import com.google.gson.Gson;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import de.otto.edison.vault.VaultToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultClient {
    private static final Logger LOG = LoggerFactory.getLogger(VaultClient.class);
    private final String vaultBaseUrl;
    private final String secretPath;
    private final VaultToken vaultToken;
    protected AsyncHttpClient asyncHttpClient = new AsyncHttpClient();

    public static String getVaultAddrFromEnv() {
        return System.getenv("VAULT_ADDR");
    }

    public static VaultClient vaultClient(String vaultBaseUrl, String secretPath, VaultToken vaultToken) {
        return new VaultClient(vaultBaseUrl, secretPath, vaultToken);
    }

    private VaultClient(String vaultBaseUrl, String secretPath, VaultToken vaultToken) {
        this.vaultBaseUrl = this.removeTrailingSlash(vaultBaseUrl);
        this.secretPath = this.removeLeadingSlash(this.removeTrailingSlash(secretPath));
        this.vaultToken = vaultToken;
    }

    public String read(String key) {
        try {
            String url = this.vaultBaseUrl + "/v1/" + this.secretPath + "/" + key;
            Response response = (Response)this.asyncHttpClient.prepareGet(url).setHeader("X-Vault-Token", this.vaultToken.getToken()).execute().get();
            if (response.getStatusCode() != 200) {
                LOG.error("can't read vault property '{}' with token '{}' from url '{}'", new Object[]{key, this.vaultToken.getToken(), url});
                throw new RuntimeException(String.format("read of vault property '%s' with token '%s' from url '%s' failed, return code is '%s'", key, this.vaultToken.getToken(), url, response.getStatusCode()));
            }
            LOG.info("read of vault property '{}' successful", (Object)key);
            return this.extractProperty(response.getResponseBody());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.error(String.format("extract of vault property '%s' failed", key), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String extractProperty(String responseBody) {
        Map responseMap = (Map)new Gson().fromJson(responseBody, Map.class);
        Map data = (Map)responseMap.get("data");
        return (String)data.get("value");
    }

    private String removeTrailingSlash(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    private String removeLeadingSlash(String url) {
        if (url.startsWith("/")) {
            return url.substring(1);
        }
        return url;
    }
}

