/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.validation.validators;

import de.otto.edison.validation.validators.IsEnum;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumValidator
implements ConstraintValidator<IsEnum, String> {
    private Set<String> availableEnumNames;
    private boolean ignoreCase;
    private boolean allowNull;

    public void initialize(IsEnum annotation) {
        Class<Enum<?>> enumClass = annotation.enumClass();
        this.availableEnumNames = Stream.of(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
        this.ignoreCase = annotation.ignoreCase();
        this.allowNull = annotation.allowNull();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return this.allowNull;
        }
        return this.availableEnumNames.stream().anyMatch(o -> {
            if (this.ignoreCase) {
                return o.equalsIgnoreCase(value);
            }
            return o.equals(value);
        });
    }
}

