/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.validation.validators;

import de.otto.edison.validation.validators.IsEnum;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ResourceBundleMessageSource;

public class EnumListValidator
implements ConstraintValidator<IsEnum, List<String>> {
    private static final String UNKNOWN_ENUMS_VALUE_MESSAGE_CODE = "unknown.enums.values";
    private final ResourceBundleMessageSource messageSource;
    private Set<String> availableEnumNames;
    private boolean ignoreCase;
    private boolean allowNull;

    public EnumListValidator(@Qualifier(value="edisonValidationMessageSource") ResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void initialize(IsEnum annotation) {
        Class<Enum<?>> enumClass = annotation.enumClass();
        this.availableEnumNames = Stream.of(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
        this.ignoreCase = annotation.ignoreCase();
        this.allowNull = annotation.allowNull();
    }

    public boolean isValid(List<String> value, ConstraintValidatorContext context) {
        if (value == null) {
            return this.allowNull;
        }
        List invalidValues = value.stream().filter(v -> !this.isValidEnum((String)v)).collect(Collectors.toList());
        if (!invalidValues.isEmpty()) {
            context.disableDefaultConstraintViolation();
            String invalidValuesString = String.join((CharSequence)",", invalidValues);
            String messageTemplate = this.messageSource.getMessage(UNKNOWN_ENUMS_VALUE_MESSAGE_CODE, new Object[]{invalidValuesString}, Locale.getDefault());
            context.buildConstraintViolationWithTemplate(messageTemplate).addConstraintViolation();
        }
        return invalidValues.isEmpty();
    }

    private boolean isValidEnum(String enumString) {
        return this.availableEnumNames.stream().anyMatch(o -> {
            if (this.ignoreCase) {
                return o.equalsIgnoreCase(enumString);
            }
            return o.equals(enumString);
        });
    }
}

