/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.validation.testsupport;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class ValidationHelper {
    private static Validator validator;

    public static <T> List<String> getViolatedFields(T apiRepresentation) {
        Set violations = validator.validate(apiRepresentation, new Class[0]);
        return violations.stream().map(ConstraintViolation::getPropertyPath).map(Path::toString).collect(Collectors.toList());
    }

    static {
        PlatformResourceBundleLocator resourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages", null, true);
        ResourceBundleMessageInterpolator messageInterpolator = new ResourceBundleMessageInterpolator((ResourceBundleLocator)resourceBundleLocator);
        validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)messageInterpolator).buildValidatorFactory().getValidator();
    }
}

