/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.validation.web;

import de.otto.edison.validation.web.ErrorHalRepresentation;
import de.otto.edison.validation.web.ErrorHalRepresentationFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.Errors;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ValidationExceptionHandler {
    private static final MediaType APPLICATION_HAL_JSON_ERROR = MediaType.parseMediaType((String)"application/hal+json; profiles=\"http://spec.otto.de/profiles/error\"");
    private final ErrorHalRepresentationFactory errorHalRepresentationFactory;

    @Autowired
    public ValidationExceptionHandler(ErrorHalRepresentationFactory errorHalRepresentationFactory) {
        this.errorHalRepresentationFactory = errorHalRepresentationFactory;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public ResponseEntity<ErrorHalRepresentation> handleException(MethodArgumentNotValidException exception) {
        return ResponseEntity.unprocessableEntity().contentType(APPLICATION_HAL_JSON_ERROR).body((Object)this.errorHalRepresentationFactory.halRepresentationForValidationErrors((Errors)exception.getBindingResult()));
    }
}

