/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.validation.web;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.otto.edison.hal.HalRepresentation;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public class ErrorHalRepresentation
extends HalRepresentation {
    private final String errorMessage;
    private final Map<String, List<Map<String, String>>> errors;

    private ErrorHalRepresentation(Builder builder) {
        super(Links.linkingTo().array(Link.profile((String)builder.profile), new Link[0]).build());
        this.errors = builder.errors;
        this.errorMessage = builder.errorMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ErrorHalRepresentation{withErrorMessage='" + this.errorMessage + "', withErrors=" + this.errors + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ErrorHalRepresentation that = (ErrorHalRepresentation)((Object)o);
        return Objects.equals(this.errors, that.errors) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.errors, this.errorMessage);
    }

    public Map<String, List<Map<String, String>>> getErrors() {
        return this.errors;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Builder {
        private Map<String, List<Map<String, String>>> errors = new HashMap<String, List<Map<String, String>>>();
        private String errorMessage;
        private String profile = "";

        private Builder() {
        }

        public ErrorHalRepresentation build() {
            return new ErrorHalRepresentation(this);
        }

        public Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder withErrors(Map<String, List<Map<String, String>>> errors) {
            this.errors = errors;
            return this;
        }

        public Builder withError(String field, String key, String message, String rejected) {
            HashMap<String, String> innerMap = new HashMap<String, String>();
            innerMap.put("key", key);
            innerMap.put("message", message);
            innerMap.put("rejected", rejected);
            List list = this.errors.getOrDefault(field, new ArrayList());
            list.add(innerMap);
            this.errors.put(field, list);
            return this;
        }

        public Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }
    }
}

