/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.togglz.repository.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import de.otto.edison.mongo.AbstractMongoRepository;
import de.otto.edison.togglz.FeatureClassProvider;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

@Repository
public class MongoFeatureRepository
extends AbstractMongoRepository<String, FeatureState>
implements StateRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MongoFeatureRepository.class);
    private static final String NAME = "_id";
    private static final String ENABLED = "enabled";
    private static final String STRATEGY = "strategy";
    private static final String PARAMETERS = "parameters";
    private final MongoCollection<Document> collection;
    private final FeatureClassProvider featureClassProvider;

    @Autowired
    public MongoFeatureRepository(MongoDatabase database, FeatureClassProvider featureClassProvider) {
        this.featureClassProvider = featureClassProvider;
        this.collection = database.getCollection("togglz");
    }

    public FeatureState getFeatureState(Feature feature) {
        Optional featureState = this.findOne(feature.name());
        if (!featureState.isPresent()) {
            return null;
        }
        return (FeatureState)featureState.get();
    }

    public void setFeatureState(FeatureState featureState) {
        this.createOrUpdate(featureState);
        LOG.info("switched feature toggle '{}' to '{}'", (Object)featureState.getFeature().name(), (Object)featureState.isEnabled());
    }

    protected MongoCollection<Document> collection() {
        return this.collection;
    }

    protected String keyOf(FeatureState value) {
        return value.getFeature().name();
    }

    protected Document encode(FeatureState value) {
        Document document = new Document();
        document.append(NAME, (Object)value.getFeature().name());
        document.append(ENABLED, (Object)value.isEnabled());
        document.append(STRATEGY, (Object)value.getStrategyId());
        document.append(PARAMETERS, (Object)value.getParameterMap());
        return document;
    }

    protected FeatureState decode(Document document) {
        String name = document.getString((Object)NAME);
        Boolean enabled = document.getBoolean((Object)ENABLED);
        String strategy = document.getString((Object)STRATEGY);
        Map parameters = (Map)document.get((Object)PARAMETERS, Map.class);
        FeatureState featureState = new FeatureState(this.resolveEnumValue(name));
        featureState.setEnabled(enabled.booleanValue());
        featureState.setStrategyId(strategy);
        for (Map.Entry parameter : parameters.entrySet()) {
            featureState.setParameter((String)parameter.getKey(), (String)parameter.getValue());
        }
        return featureState;
    }

    protected void ensureIndexes() {
    }

    private Feature resolveEnumValue(String name) {
        Class enumType = this.featureClassProvider.getFeatureClass();
        return (Feature)Enum.valueOf(enumType, name);
    }
}

