/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.testsupport.util;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonMap {
    private final Object jsonObject;

    private JsonMap(Object jsonObject) {
        this.jsonObject = jsonObject;
    }

    public static JsonMap jsonMapFrom(Map<?, ?> map) {
        return new JsonMap(map);
    }

    public static JsonMap jsonMapFrom(Object map) {
        if (map instanceof JsonMap) {
            return (JsonMap)map;
        }
        return new JsonMap(map);
    }

    public void remove(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (!this.is(Map.class)) {
            throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
        }
        ((Map)this.jsonObject).remove(key);
    }

    public JsonMap get(String s) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            String[] segments = s.split("\\.");
            if (segments.length < 2) {
                Object object = ((Map)this.jsonObject).get(s);
                return object != null ? new JsonMap(object) : null;
            }
            return this.get(segments[0]).get(s.substring(s.indexOf(".") + 1));
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public String getString(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            if (value == null) {
                return null;
            }
            return ((Object)value).toString();
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public String getString(String key, String defaultValue) {
        String result = this.getString(key);
        return result != null ? result : defaultValue;
    }

    public Boolean getBoolean(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            return value != null ? Boolean.valueOf(((Object)value).toString()) : null;
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean result = this.getBoolean(key);
        return result != null ? result : defaultValue;
    }

    public Integer getInt(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            return value != null ? Integer.valueOf(((Object)value).toString()) : null;
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Integer getInt(String key, Integer defaultValue) {
        Integer result = this.getInt(key);
        return result != null ? result : defaultValue;
    }

    public Long getLong(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            return value != null ? Long.valueOf(((Object)value).toString()) : null;
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public long getLong(String key, long defaultValue) {
        Long result = this.getLong(key);
        return result != null ? result : defaultValue;
    }

    public Float getFloat(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            return value != null ? Float.valueOf(((Object)value).toString()) : null;
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Float getFloat(String key, float defaultValue) {
        Float result = this.getFloat(key);
        return Float.valueOf(result != null ? result.floatValue() : defaultValue);
    }

    public Double getDouble(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            return value != null ? Double.valueOf(((Object)value).toString()) : null;
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Double getDouble(String key, double defaultValue) {
        Double result = this.getDouble(key);
        return result != null ? result : defaultValue;
    }

    public Object getObject(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            return this.get(key);
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Date getDate(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            JsonMap value = this.get(key);
            if (value == null) {
                return null;
            }
            if (value.is(Date.class)) {
                return (Date)value.jsonObject;
            }
            if (value.is(String.class)) {
                return Date.from(Instant.parse(value.toString()));
            }
            throw new ClassCastException("Value of " + key + " is not a date but a " + value.getClass().getSimpleName());
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Instant getInstant(String key) {
        if (this.jsonObject == null) {
            throw new NullPointerException("json object is null");
        }
        if (this.is(Map.class)) {
            String value = this.getString(key);
            return value != null ? Instant.parse(value) : null;
        }
        throw new IllegalArgumentException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public <T> List<T> asListOf(Class<T> type) {
        if (this.jsonObject == null) {
            return null;
        }
        if (this.is(List.class)) {
            if (JsonMap.class.isAssignableFrom(type)) {
                return ((List)this.jsonObject).stream().map(JsonMap::new).collect(Collectors.toList());
            }
            return (List)this.jsonObject;
        }
        throw new ClassCastException("not a collection but a " + this.jsonObject.getClass().getSimpleName());
    }

    public <T> Set<T> asSetOf(Class<T> type) {
        if (this.jsonObject == null) {
            return null;
        }
        if (this.is(Collection.class)) {
            return new HashSet((Collection)this.jsonObject);
        }
        throw new ClassCastException("not a collection but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Map<String, Object> asMap() {
        if (this.jsonObject == null) {
            return Collections.emptyMap();
        }
        if (this.is(Map.class)) {
            return (Map)this.jsonObject;
        }
        throw new IllegalStateException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public <T> Map<T, Object> asMapWithKeysOfType(Class<T> type) {
        if (this.jsonObject == null) {
            return Collections.emptyMap();
        }
        if (this.is(Map.class)) {
            return (Map)this.jsonObject;
        }
        throw new IllegalStateException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    public Set<String> keySet() {
        if (this.jsonObject == null) {
            return Collections.emptySet();
        }
        if (this.is(Map.class)) {
            return ((Map)this.jsonObject).keySet();
        }
        throw new IllegalStateException("not a map but a " + this.jsonObject.getClass().getSimpleName());
    }

    private boolean is(Class<?> type) {
        return type.isAssignableFrom(this.jsonObject.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonMap jsonMap = (JsonMap)o;
        return !(this.jsonObject != null ? !this.jsonObject.equals(jsonMap.jsonObject) : jsonMap.jsonObject != null);
    }

    public int hashCode() {
        return this.jsonObject != null ? this.jsonObject.hashCode() : 0;
    }

    public String toString() {
        return this.jsonObject.toString();
    }
}

