/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.testsupport.togglz;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.metadata.enums.EnumFeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.SimpleFeatureUser;
import org.togglz.core.util.Validate;

public class TestFeatureManager
implements FeatureManager {
    private final Class<? extends Feature> featureEnum;
    private final Map<String, FeatureState> featureStates = new HashMap<String, FeatureState>();

    public TestFeatureManager(Class<? extends Feature> featureEnum) {
        Validate.notNull(featureEnum, (String)"The featureEnum argument is required");
        Validate.isTrue((boolean)featureEnum.isEnum(), (String)"This feature manager currently only works with feature enums");
        this.featureEnum = featureEnum;
    }

    public String getName() {
        return this.getClass().getSimpleName() + ":" + this.featureEnum.getSimpleName();
    }

    public Set<Feature> getFeatures() {
        return new HashSet<Feature>(Arrays.asList(this.featureEnum.getEnumConstants()));
    }

    public FeatureMetaData getMetaData(Feature feature) {
        return new EnumFeatureMetaData(feature);
    }

    public boolean isActive(Feature feature) {
        if (this.featureStates.containsKey(feature.name())) {
            return this.featureStates.get(feature.name()).isEnabled();
        }
        return false;
    }

    public FeatureUser getCurrentFeatureUser() {
        boolean featureAdmin = true;
        return new SimpleFeatureUser("p13n-testing-user", featureAdmin);
    }

    public FeatureState getFeatureState(Feature feature) {
        if (this.featureStates.containsKey(feature.name())) {
            return this.featureStates.get(feature.name());
        }
        return new FeatureState(feature, false);
    }

    public void setFeatureState(FeatureState state) {
        if (state.getFeature() == null) {
            throw new RuntimeException("missing feature in state");
        }
        this.featureStates.put(state.getFeature().name(), state);
    }

    public List<ActivationStrategy> getActivationStrategies() {
        return Collections.emptyList();
    }

    public TestFeatureManager setEnabled(Feature feature, boolean enabled) {
        if (this.featureStates.containsKey(feature.name())) {
            this.featureStates.get(feature.name()).setEnabled(enabled);
        } else {
            this.featureStates.put(feature.name(), new FeatureState(feature, false));
        }
        return this;
    }

    public TestFeatureManager enable(Feature feature) {
        return this.setEnabled(feature, true);
    }

    public TestFeatureManager disable(Feature feature) {
        return this.setEnabled(feature, false);
    }

    public TestFeatureManager enableAll() {
        for (FeatureState featureState : this.featureStates.values()) {
            featureState.setEnabled(false);
        }
        return this;
    }

    public TestFeatureManager disableAll() {
        for (FeatureState featureState : this.featureStates.values()) {
            featureState.setEnabled(false);
        }
        return this;
    }
}

