/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.testsupport.togglz;

import de.otto.edison.testsupport.togglz.TestFeatureManager;
import de.otto.edison.testsupport.togglz.TestFeatureManagerProvider;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;

public class FeatureManagerSupport {
    public static void allEnabledFeatureConfig(Class<? extends Feature> featureClass) {
        TestFeatureManager featureManager = new TestFeatureManager(featureClass);
        TestFeatureManagerProvider.setFeatureManager(featureManager);
        FeatureManagerSupport.allEnabledFeatureConfig(featureManager);
    }

    public static void allEnabledFeatureConfig(FeatureManager featureManager) {
        FeatureManagerSupport.enableAllFeaturesThatAreOkToEnableByDefaultInAllTests(featureManager);
        FeatureContext.clearCache();
    }

    public static void allDisabledFeatureConfig(Class<? extends Feature> featureClass) {
        TestFeatureManager featureManager = new TestFeatureManager(featureClass);
        TestFeatureManagerProvider.setFeatureManager(featureManager);
        FeatureManagerSupport.allDisabledFeatureConfig(featureManager);
    }

    public static void allDisabledFeatureConfig(FeatureManager featureManager) {
        featureManager.getFeatures().forEach(feature -> featureManager.setFeatureState(new FeatureState(feature, false)));
        FeatureContext.clearCache();
    }

    public static void disable(Feature feature) {
        FeatureContext.getFeatureManager().setFeatureState(new FeatureState(feature, false));
    }

    private static void enableAllFeaturesThatAreOkToEnableByDefaultInAllTests(FeatureManager featureManager) {
        featureManager.getFeatures().forEach(feature -> {
            if (FeatureManagerSupport.shouldRunInTests(featureManager, feature)) {
                featureManager.setFeatureState(new FeatureState(feature, true));
            }
        });
    }

    public static boolean shouldRunInTests(Feature feature) {
        return FeatureManagerSupport.shouldRunInTests(FeatureContext.getFeatureManager(), feature);
    }

    private static boolean shouldRunInTests(FeatureManager featureManager, Feature feature) {
        return !featureManager.getMetaData(feature).getLabel().contains("[inactiveInTests]");
    }

    public static void enable(Feature feature) {
        FeatureContext.getFeatureManager().setFeatureState(new FeatureState(feature, true));
    }
}

